package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.Action;
import bot.Bot;
import java.io.Serializable;
import javax.xml.bind.annotation.*;


/**
 * Sends FOLLOW to the global message channel thus provoking the Commandable bot to follow him, thought there
 * should be some kind of handshake, where the commandable bot would send a confirmation of the reception -> e.g. when he 
 * spots the agent (when bot is sending it he only sees the commandable bot, not necesarily vice versa)
 * @author Ondrej
 */
@XmlRootElement
public class Follow extends AtomicAction implements Serializable {
    Player player = null;
    @Override
    public void execute() {
        

        if (counter == 0)
            initialisation();
        counter = agent.getCurrentTime();

        if (player != null)
            this.agent.getAct().act(new SendMessage().setText(player.getId() + " FOLLOW " + agent.agentInfo.getName()));
        else
            this.agent.getAct().act(new SendMessage().setText("FOLLOW"));
        this.agent.getLog().info("Sending Follow.");
    }
    /**
     * succeeds when message sended - can be more profound with some hand shake...
     * @return
     */
    @Override
    public boolean succeeded() {        
        return true;
    }
    
    @Override
    public boolean failed() {
        if ((counter - actionStart) > parent.timeLimit)
            return true;
        return false;
    }
    
    public Follow(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.FOLLOW;
    }   

    @Override
    protected void initialisation() {
        super.initialisation();
        if (this.parent.satisfyingItems.get(AffordanceType.PLAYER) != null)
            player = (Player) this.parent.satisfyingItems.get(AffordanceType.PLAYER).item;
        else
            agent.getLog().severe("Unsatisfied affordance! no player to go with to the GAME ZONE!!!");
    }
}
