package atomicActions;

import bot.Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;

import decisionMakingSystem.Action;
import java.io.Serializable;

/**
 * Drink, Drinking as long as the time limit says
 * @author Ondrej
 */
public class Drink extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Drinking finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }
    
    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {        
        if (counter == 0) {
            agent.getLog().info("Drinking");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }
    
    public Drink (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.DRINK;
    }
    
}