/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import atomicActions.AtomicAction;
import atomicActions.AtomicActions;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import decisionMakingSystem.Action;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.SearchRandom;
import java.util.ArrayList;

class AtomicSearchRandom
extends AtomicAction {
    private DecisionModuleImpl module;
    ArrayList<Item> itemsToRunAround = null;
    EItem item = null;
    AffordanceType affType = null;

    public AtomicSearchRandom(Action parent, DecisionModuleImpl module) {
        super(parent, module.agent);
        this.module = module;
        this.type = AtomicActions.SEARCH_RANDOM;
        this.dModule = module;
    }

    @Override
    public void execute() {
        if (this.counter == 0) {
            this.initialisation();
        }
        this.item = this.module.perceptiveField.getPerceivedItemOfAffordance(this.affType);
        if (this.item == null) {
            this.item = this.module.things.seeingItem(this.affType);
        }
        if (this.item == null) {
            this.agent.runAroundItemsInTheMap(this.itemsToRunAround, false);
        } else if (this.item.getLocation() != null) {
            this.agent.getAct().act((CommandMessage)new Move().setFirstLocation(this.item.getLocation()));
        }
        this.counter = this.agent.getCurrentTime();
    }

    @Override
    public boolean succeeded() {
        Action parentAction = this.parent.intention.getAncestorAction();
        if (this.module.inventory.hasItemOfAffordance(this.affType)) {
            this.item = this.module.inventory.getItemOfAffordance(this.affType);
            this.module.perceptiveField.satisfyAffordance(parentAction, this.affType, this.item);
            this.agent.getLog().info("Atomic search random - " + (Object)((Object)this.affType) + " - finished. Duration :" + this.counter + " rounds.");
            return true;
        }
        if (this.item == null || this.item.cathegory == null) {
            return false;
        }
        boolean succeeded = false;
        switch (this.item.cathegory) {
            case PLAYER: {
                succeeded = true;
                break;
            }
            case PLACE: {
                if (this.agent.getLocation() == null || !(this.item.getLocation().getDistance(this.agent.getLocation()) < 505.0)) break;
                succeeded = true;
            }
        }
        if (succeeded) {
            this.item.decreaseAttractivity();
            this.module.perceptiveField.satisfyAffordance(parentAction, this.affType, this.item);
            this.agent.getLog().info("Atomic search random - " + (Object)((Object)this.affType) + " - finished. Duration :" + this.counter + " rounds.");
        }
        return succeeded;
    }

    @Override
    public boolean failed() {
        if (this.counter - this.actionStart > this.parent.timeLimit) {
            this.agent.getLog().info("Search of " + (Object)((Object)this.affType) + " failed.");
            return true;
        }
        return false;
    }

    @Override
    protected void initialisation() {
        super.initialisation();
        ArrayList<Item> weapons = this.agent.getKnownWeapons();
        this.itemsToRunAround = new ArrayList();
        this.affType = ((SearchRandom)this.parent).affordance;
        for (Item weapon : weapons) {
            this.itemsToRunAround.add(weapon);
        }
        this.agent.getAct().act((CommandMessage)new Configuration().setAction(this.type.toString()).setName(this.type.toString() + " " + (Object)((Object)this.affType)));
    }
}

