/*
 * Decompiled with CFR 0.152.
 */
package decisionMakingSystem;

import atomicActions.AtomicAction;
import atomicActions.AtomicActions;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Rotate;
import decisionMakingSystem.Action;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.DecisionModuleImpl;
import decisionMakingSystem.EItem;
import decisionMakingSystem.SearchEnvironment;

class AtomicSearchEnvironment
extends AtomicAction {
    private DecisionModuleImpl module;
    private EItem item = null;
    private AffordanceType affType = null;
    protected static final int PLACE_MIN_DIST = 180;

    public AtomicSearchEnvironment(Action parent, DecisionModuleImpl module) {
        this.parent = parent;
        this.agent = module.agent;
        this.module = module;
        this.type = AtomicActions.SEARCH_ENVIRONMENT;
        this.dModule = module;
    }

    @Override
    public void execute() {
        if (this.counter == 0) {
            this.initialisation();
        }
        this.counter = this.agent.getCurrentTime();
        this.item = this.module.perceptiveField.getPerceivedItemOfAffordance(this.affType);
        if (this.item == null) {
            this.item = this.module.things.seeingItem(this.affType);
            this.agent.getAct().act((CommandMessage)new Rotate().setAmount(Integer.valueOf(20000)));
        } else if (this.item.getLocation() != null) {
            this.agent.safeRunToLocation(this.item.getLocation());
            return;
        }
    }

    @Override
    public boolean succeeded() {
        Action parentAction = this.parent.intention.getAncestorAction();
        if (this.module.inventory.hasItemOfAffordance(this.affType)) {
            this.item = this.module.inventory.getItemOfAffordance(this.affType);
            this.module.perceptiveField.satisfyAffordance(parentAction, this.affType, this.item);
            this.agent.getLog().info("Atomic search environment - " + (Object)((Object)this.affType) + " - finished. Duration :" + this.counter + " rounds.");
            return true;
        }
        if (this.item == null || this.item.cathegory == null) {
            return false;
        }
        boolean succeeded = false;
        switch (this.item.cathegory) {
            case PLAYER: {
                succeeded = true;
                break;
            }
            case PLACE: {
                if (this.agent.getLocation() == null || !(this.agent.getLocation().getDistance(this.item.getLocation()) < 180.0)) break;
                succeeded = true;
            }
        }
        if (succeeded) {
            this.item.decreaseAttractivity();
            this.module.perceptiveField.satisfyAffordance(parentAction, this.affType, this.item);
            this.agent.getLog().info("Atomic search environment - " + (Object)((Object)this.affType) + " - finished. Duration :" + this.counter + " rounds.");
        }
        return succeeded;
    }

    @Override
    public boolean failed() {
        return this.counter - this.actionStart > this.parent.timeLimit;
    }

    @Override
    protected void initialisation() {
        super.initialisation();
        this.affType = ((SearchEnvironment)this.parent).affordance;
        this.agent.getLog().info("Start searching for: " + (Object)((Object)this.affType) + " on behalf of " + this.parent.intention.getAncestorAction().name);
        this.agent.getAct().act((CommandMessage)new Configuration().setAction(this.type.toString()).setName(this.type.toString() + " " + (Object)((Object)this.affType)));
    }
}

