/*
 * Decompiled with CFR 0.152.
 */
package bot;

import bot.Bot;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Jump;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Logger;

public class PathFinderModule {
    IAct act;
    IVisionWorldView worldView;
    AgentInfo agentInfo;
    public HashMap<UnrealId, NavPoint> knownNavPoints = new HashMap();
    public ArrayList<ILocated> myPath = new ArrayList();
    public boolean pathRequested = false;
    public boolean pathReceived = false;
    public double pathRequestedTime = 0.0;
    public int pathRerequestDelay = 3;
    public Location nearestNavLocation;
    public double lastJumpTime = 0.0;
    public double jumpDelay = 10.0;
    public Location lastFollowPathLocation;
    public double currentTime;
    private final Logger log;
    private ArrayList<Item> itemsToRunAround = new ArrayList();
    private int currentIndexOfItem;
    static double approachRadius = 150.0;
    IWorldEventListener<MapPointListObtained> myMapListObtainedListener = new IWorldEventListener<MapPointListObtained>(){

        public void notify(MapPointListObtained event) {
            MapPointListObtained map = event;
            PathFinderModule.this.knownNavPoints.putAll(map.getNavPoints());
        }
    };
    public IWorldEventListener<BeginMessage> myBegListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage bm) {
            PathFinderModule.this.currentTime = bm.getTime();
        }
    };

    protected Location getNearestNavLocation(Location targetLocation) {
        NavPoint result = null;
        for (NavPoint nav : this.knownNavPoints.values()) {
            if (result == null) {
                result = nav;
                continue;
            }
            if (!(nav.getLocation().getDistance(targetLocation) < result.getLocation().getDistance(targetLocation))) continue;
            result = nav;
        }
        return result.getLocation();
    }

    public boolean runAroundItemsInTheMap(ArrayList<Item> newItemsToRunAround) {
        if (newItemsToRunAround == null || newItemsToRunAround.isEmpty()) {
            return false;
        }
        if (this.itemsToRunAround.isEmpty()) {
            this.itemsToRunAround.addAll(newItemsToRunAround);
            this.currentIndexOfItem = 0;
        } else if (!this.itemsToRunAround.equals(newItemsToRunAround)) {
            this.itemsToRunAround.clear();
            this.itemsToRunAround.addAll(newItemsToRunAround);
            this.currentIndexOfItem = 0;
        }
        if (this.currentIndexOfItem >= this.itemsToRunAround.size()) {
            this.currentIndexOfItem = 0;
        }
        if (this.agentInfo.atLocation((ILocated)this.itemsToRunAround.get(this.currentIndexOfItem).getLocation(), approachRadius)) {
            ++this.currentIndexOfItem;
            if (this.currentIndexOfItem >= this.itemsToRunAround.size()) {
                this.currentIndexOfItem = 0;
            }
        }
        this.goToLocation(this.itemsToRunAround.get(this.currentIndexOfItem).getLocation());
        return true;
    }

    public boolean goToLocation(Location targetLocation) {
        return false;
    }

    PathFinderModule(Bot agent) {
        this.act = agent.getAct();
        this.worldView = agent.getWorldView();
        this.agentInfo = agent.agentInfo;
        this.log = agent.getLog();
        this.initialize(agent);
    }

    private IAct getAct() {
        return this.act;
    }

    private void initialize(Bot agent) {
    }

    private IWorldView getWorldView() {
        return this.worldView;
    }

    private void handleBotStuck() {
        if (this.pathReceived && this.currentTime - this.pathRequestedTime > 5.0 && this.agentInfo.getVelocity().size() < 50.0) {
            if (this.currentTime - this.lastJumpTime > this.jumpDelay) {
                this.getAct().act((CommandMessage)new Jump());
                this.lastJumpTime = this.currentTime;
            } else if (this.currentTime - this.lastJumpTime > 3.0) {
                Random rnd = new Random();
                this.getAct().act((CommandMessage)new Move().setFirstLocation(this.agentInfo.getLocation().add(new Location((rnd.nextDouble() - 0.5) * 200.0, (rnd.nextDouble() - 0.5) * 200.0, 0.0))));
            }
        }
    }
}

