package utils;

import decisionMakingSystem.*;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * this class serves for definition of functions of activation of root processes so 
 * it will be possible to export and import it via XML
 * <br>
 * though that brings some limitation on their specification, they can be only linear
 * technicaly we can write the Interval more as a Function or something so it will have some more
 * parameters and will calculate according to them some polynom for instance. But for sake of a simplicity
 * this function is linear for the moment
 * @author Ondrej
 */
@XmlRootElement
public class Interval implements Cloneable, Serializable {
    /** left side */
    @XmlElement
    private int leftSide = 0;
    /** right side */
    @XmlElement
    private int rightSide = 0;
    /** value of the function */
    @XmlElement
    private int value = 0;
    
    /**
     * @param x
     * @return true if x is in the interval
     */
    public boolean isInInterval(int x) {
        if ((x >= getLeftSide()) && (x <= getRightSide())) 
            return true;
        return false;
    }
    
    public Interval(int a, int b, int value) {
        this.leftSide = a;
        this.rightSide = b;
        this.value = value;
    }
    
    public Interval() {}
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (this == null || obj == null)
            return false;
        if (!obj.getClass().equals(this.getClass()))
            return false;
        Interval tmp = (Interval) obj;
        if ((tmp.rightSide == this.rightSide)
            && tmp.leftSide == this.leftSide
            && tmp.value == this.value)
            return true;
        return false;
    }
    
    @Override
    public Object clone() {
        return new Interval(this.leftSide, this.rightSide, this.value);
    }
    
    public int getRightSide() {
        return rightSide;
    }
    
    public int getLeftSide() {
        return leftSide;
    }
    
    public int getIntervalSize() {
        if (rightSide - leftSide > 0)
            return rightSide - leftSide;
        return 0;
    }
    
    /**
     * @param x
     * @return the value of the function in the specified interval
     */
    public int valueInTime (int x) {
        if (isInInterval(x))
            return getValue();
        else
            return 0;
    }

    public int getValue() {
        return value;
    }
    @Override
    public String toString() {
        return "(<" + this.leftSide + ", " + this.rightSide + ">; " + this.value + ")";
    }
}