package scheduler;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * This structure is used to store the schedule entries for probabilistic
 * scheduler so we can store them in xml files.
 *
 * @author knight
 */
@XmlRootElement
public class ProbabilisticSchedulerTransitionEntry implements Serializable {

    @XmlElement
    /** Probability of the transition */
    public double probability;
    @XmlElement
    /** name of the intention we go from */
    public String fromIntention = null;
    @XmlElement
    /** name of the intention we go to*/
    public String toIntention = null;

    public ProbabilisticSchedulerTransitionEntry(double probability, String fromIntention, String toIntention) {
        this.probability = probability;
        this.fromIntention = fromIntention;
        this.toIntention = toIntention;
    }

    ProbabilisticSchedulerTransitionEntry() {
    };

    @Override
    public String toString() {
        String result = "FromIntention: " + this.fromIntention;
        result += "ToIntention: " + this.toIntention;
        result += "Probability: " + this.probability;
        return result;
    }

}
