package decisionMakingSystem;

import bot.*;
import atomicActions.*;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import java.util.ArrayList;
import java.util.HashMap;
import utils.TimeUtils;

/**
 * search environment - random search, so far it just runs around items
 * but it can be more random by running from navigation point to navigation point
 * and it will be necessary as it will search places? well, that depends on the model
 * @author Ondrej
 */
class AtomicSearchRandom extends AtomicAction {
    private DecisionModuleImpl module;
    public AtomicSearchRandom (Action parent, DecisionModuleImpl module) {
        //super();
        //this.parent = parent;
        //this.agent = module.agent;
        super(parent, module.agent); //TODO: why is this wrong? 4x
        this.module = module;
        this.type = AtomicActions.SEARCH_RANDOM;
        dModule = module;
    }
    
    ArrayList<Item> itemsToRunAround = null;
    EItem item = null;
    AffordanceType affType = null;
    @Override
    public void execute() {
        
        if (counter == 0) {
            initialisation();
        }
        item = this.module.perceptiveField.getPerceivedItemOfAffordance(affType);
        if (item == null)
            item = this.module.things.seeingItem(affType);
        if (item == null) {
            // doesn't see anything => run around the map
            this.agent.runAroundItemsInTheMap(itemsToRunAround, false);
        } else {
            // see an item and it is pickable or a place -> run to it
            if (item.getLocation() != null)
                this.agent.getAct().act(new Move().setFirstLocation(item.getLocation()));
        }
        this.counter = agent.getCurrentTime();
    }
    
    @Override
    public boolean succeeded() {
        Action parentAction = this.parent.intention.getAncestorAction(); // link to the action which called Want
        // has picked up an item 
        if (this.module.inventory.hasItemOfAffordance(affType)) {
            item = this.module.inventory.getItemOfAffordance(affType); // item from inventory
            this.module.perceptiveField.satisfyAffordance(parentAction, affType, item);
            agent.getLog().info("Atomic search random - " + this.affType + " - finished. Duration :" + counter + " rounds.");
            return true;
        }   
        // no hint of an item
        if (item == null || item.cathegory == null) { 
            return false;
        }
        boolean succeeded = false;
        switch (item.cathegory) {
            case PLAYER: // see player -> satisfy the affordance
                succeeded = true;
                break;
            case PLACE:
                // place and agent got close enought to it
                if (agent.getLocation() != null)
                    if (item.getLocation().getDistance(agent.getLocation()) < 505) {
                        succeeded = true;
                        break;
                    }
                break;
        }
        if (succeeded) {
            item.decreaseAttractivity();
            this.module.perceptiveField.satisfyAffordance(parentAction, affType, item);
            agent.getLog().info("Atomic search random - " + this.affType + " - finished. Duration :" + counter + " rounds.");
        }
        return succeeded;
    }
    
    @Override
    public boolean failed() {
        if ((counter - actionStart) > parent.timeLimit) {
            agent.getLog().info("Search of " + this.affType + " failed.");
            return true;
        }
        return false;
    }
    
    @Override
    protected void initialisation() {
        //actionStart = agent.getCurrentTime();
        super.initialisation();
        ArrayList<Item> weapons = this.agent.getKnownWeapons();
        itemsToRunAround = new ArrayList<Item>();
        affType = ((SearchRandom)parent).affordance;
        for (Item weapon : weapons) {
            this.itemsToRunAround.add(weapon);
        }
        //echoAction(type.toString() + " " + affType);
        this.agent.getAct().act(new Configuration().setAction(this.type.toString()).setName(this.type.toString() + " " + affType));
    }   
}

class SearchRandom extends Action {
    public AffordanceType affordance;
    
    public SearchRandom(AffordanceType affordance, DecisionModuleImpl module, Intention intention) {
        super();
        this.satisfyingItems.put(affordance, null);
        this.affordance = affordance;
        this.atomicActions = new ArrayList<AtomicAction>();
        this.atomicActions.add(new AtomicSearchRandom(this, module));
        this.name = "_Search Random " + affordance;
        this.activity = intention.getActivity();
        this.state = ActionStates.PRESTATE;
        this.timeLimit = TimeUtils.minutesToTicksOfLogic(GlobalParameters.SEARCH_RANDOM_LENGHT);
        this.intention = intention; // link to want:)
    }
}