package decisionMakingSystem;

import atomicActions.*;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import java.util.ArrayList;
import java.util.Collections;
import utils.TimeUtils;


/**
 * queries memory for the thing with searched affordance
 * @author Ondrej
 */
class AtomicSearchMemory extends AtomicAction {
    /** result of the memory querry */
    private ArrayList<ItemRecord> itemRecords = null;
    /** current location bot is running to */
    private ItemRecord probe = null;
    /** index in the item records */
    private int index = 0;
    /** found item */
    private EItem item = null;
    /** searched affordance */
    private AffordanceType affType = null;
    DecisionModuleImpl module;

    public AtomicSearchMemory (Action parent, DecisionModuleImpl module) {
        super();
        this.parent = parent;
        this.agent = module.agent;
        //super(parent, module.agent);
        this.module = module;
        this.type = AtomicActions.SEARCH_MEMORY;
        dModule = module;
    }
    
    private ItemRecord getNextLocation() {
        if (this.itemRecords == null || index >= this.itemRecords.size())
            return null;
        ItemRecord result = this.itemRecords.get(index);
        index++;
        if (result == null)
            return null;
        // if the probability that it will be there is high enough and he hasn't tried too many places -> return location
        if (result.probability > AgentParameters.biasProbability && index < AgentParameters.numberOfTriedPlacesInMemory)
            return result;
        return null;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            // send a memory querry to get a list of locations to try out
            initialisation();
        }
        this.counter = agent.getCurrentTime();
        agent.getLog().warning("AFFTYPE: " +affType.toString());
        item = this.module.perceptiveField.getPerceivedItemOfAffordance(affType); // if sees it already
        if (item == null)
            item = this.module.things.seeingItem(affType); // or spots it
        else {
          if (agent.getSeeItem(item.getId()) != null) {
            agent.getAct().act(new Move().setFirstLocation(item.getLocation()));
          } else {
            if (item.getLocation() != null) {
                this.agent.safeRunToLocation(item.getLocation()); // run to it
                return;
            }
          }
        }
        if (probe == null) // choose location
            probe = getNextLocation();
        else
            // if on the location and not found -> report missing and get next
            if (this.agent.getLocation() != null) {
                if (this.agent.getLocation().getDistance(probe.location) < 20 && !succeeded() ) {
                    agent.getLog().warning("Failed to find it: agent loc:" + agent.getLocation()
                            + " report missing: " + probe);
                    probe.missed(module.counter); // failed to find in on the spot -> feed-back
                    probe = getNextLocation();

                }
            }
        if (probe != null) { // if there is a location, run to it
            this.agent.safeRunToLocation(probe.location);
        }
    }

    @Override
    public boolean succeeded() {
        Action parentAction = this.parent.intention.getAncestorAction(); // link to the action which called Want
        // has picked up an item 
        if (this.module.inventory.hasItemOfAffordance(affType)) {
            probe.found(module.counter); // succeeded to find in on the spot -> feed-back
            item = this.module.inventory.getItemOfAffordance(affType); // item from inventory
            this.module.perceptiveField.satisfyAffordance(parentAction, affType, item);
            agent.getLog().info("Atomic search memory - " + this.affType + " - finished. Duration :" + counter + " rounds.");
            return true;
        }   
        // no hint of an item
        if (item == null || item.cathegory == null) { 
            return false;
        }
        boolean succeeded = false;
        switch (item.cathegory) {
            case PLAYER: // see player -> satisfy the affordance
                succeeded = true;
                break;
            case PLACE:
                // place and agent got close enought to it
                if (agent.getLocation() != null)
                    if (agent.getLocation().getDistance(item.getLocation()) < 505) {
                        succeeded = true;
                    }
                break;
        }
        if (succeeded) {
            item.decreaseAttractivity();
            this.module.perceptiveField.satisfyAffordance(parentAction, affType, item);
            probe.found(module.counter); // succeeded to find in on the spot -> feed-back
            agent.getLog().info("Atomic search memory - " + this.affType + " - finished. Duration :" + counter + " rounds.");
        }
        return succeeded;
    }
    
    @Override
    public boolean failed() {
        if ((counter - actionStart) > parent.timeLimit) {
            return true;
        }
        if (probe == null)
            return true;
        return false;
    }

    @Override
    protected void initialisation() {
        //actionStart = agent.getCurrentTime();
        super.initialisation();
        
        affType = ((SearchMemory)parent).affordance;

        this.itemRecords = this.agent.itemMemory.getLocationOfAffordances(affType, this.module.counter);
        if (this.itemRecords == null || this.itemRecords.isEmpty())
            return;
        Collections.sort(this.itemRecords);
        probe = itemRecords.get(0); // first I take no matter what - as it is good to go on the first place 
                                                    // on mind even if we are not sure if it is there
        index++;
        //echoAction(type.toString() + " " + affType);
        this.agent.getAct().act(new Configuration().setAction(this.type.toString()).setName(this.type.toString() + " " + affType));
        // this.agent.getLogger().user().info("Resulted places to run around: " + itemRecords);
    }
    

}
class SearchMemory extends Action {
    public AffordanceType affordance = null;
    
    public SearchMemory (AffordanceType affordance, DecisionModuleImpl module, Intention intention) {
        super();
        this.satisfyingItems.put(affordance, null);
        this.affordance = affordance;
        this.atomicActions = new ArrayList<AtomicAction>();
        this.atomicActions.add(new AtomicSearchMemory(this, module));
        this.name = "_Search Memory " + affordance;
        this.state = ActionStates.PRESTATE;
        this.activity = intention.getActivity();
        this.timeLimit = TimeUtils.minutesToTicksOfLogic(60);
        this.intention = intention; // link to want:)
    }        
}