package decisionMakingSystem;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import bot.Bot;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Inventory cares about items agent picked up. It stores them and responds to inventory related
 * requests. 
 * 
 * @author Ondrej
 */
public class Inventory {

    /** list of collected items */
    public ArrayList<ItemPickedUp> collectedItems = null;
    /** list of collected episodic items */
    public ArrayList<EItem> collectedEItems = null;
    /** link on the agent - to register listeners, querry built-in agent's inventory */
    public Bot agent = null;
    /** decision making system module */
    public DecisionModuleImpl module = null;
    /** number of items bot can hold/carry at one time */
    public static final int inventorySize = 3; // not used at the moment
    private boolean ready = false;

    /**
     */
    private class ItemPickedUpListener implements IWorldEventListener<ItemPickedUp> {

        @Override
        public void notify(ItemPickedUp event) {
            EItem newEItem = module.things.processItem(event);
            if (newEItem != null) {
                addItemToInventory(newEItem);
                agent.getLog().fine("Picked up item: " + newEItem.getClass() + (newEItem != null ? " aka: " + newEItem.name : ""));
            }
            
        }

        /**
         * Constructor. Registers itself on the given WorldView object.
         * @param worldView WorldView object to listent to.
         */
        public ItemPickedUpListener(IWorldView worldView) {
            worldView.addEventListener(ItemPickedUp.class, this);
        }
    }
    /** ItemPickedUp listener */
    ItemPickedUpListener itemPickedUpListener;

    public Inventory(Bot agent, DecisionModuleImpl module) {
        this.agent = agent;
        this.module = module;        
        collectedItems = new ArrayList<ItemPickedUp>();
        collectedEItems = new ArrayList<EItem>();
        itemPickedUpListener = new ItemPickedUpListener(agent.getWorldView());
    }

    // TODO: try to call it
    public void midnightUpdate() {
        collectedItems = new ArrayList<ItemPickedUp>();
        collectedEItems = new ArrayList<EItem>();
    }

    /**
     * true if there is an item of specified unreal item class
     * @param pickedType - unreal item class
     * @return true if there is some item of the class
     */
    public boolean hasItemOfClass(String pickedType) {
        for (ItemPickedUp item : collectedItems) {
            if (pickedType.contains(item.getType().toString())) // this is because of the way UT names things - Minigun is picked up weapon,
            // MinigunPickup is thing laying on the ground
            {
                return true;
            }
        }
        return false;
    }

    /**
     * @param affordance
     * @return true if there is some item of the provided affordance
     */
    public boolean hasItemOfAffordance(AffordanceType affordance) {
        for (EItem item : collectedEItems) {
            for (Affordance aff : item.getAffordances()) {
                if (aff.type.equals(affordance)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * @param affordance
     * @return return item of the provided affordance, null if there is not any
     */
    public EItem getItemOfAffordance(AffordanceType affordance) {
        for (EItem item : collectedEItems) {
            for (Affordance aff : item.getAffordances()) {
                if (aff == null || aff.type == null) {
                    this.agent.getLog().severe("affordance or its type are null! Item:" + item + " Affordance" + affordance);
                    continue;
                }
                if (aff.type.equals(affordance)) {
                    return item;
                }
            }
        }
        return null;
    }

    /**
     * well, can just remove him from items and bot would think that he doesn't have it with himself;)
     *
     * but I will throw it away to have more fun:)
     * @param item
     */
    public void throwAway(EItem item) {
        if (collectedEItems.contains(item)) {
            collectedEItems.remove(item);
            /* TODO: throwing items out
            if (item.cathegory.equals(ItemCathegory.INVENTORY) && item.item.UnrealID.contains("Weapon")) {
                this.agent.getBody().changeWeapon((AddWeapon) item.item); // AddWeapon won't work I think, at least it is quite probable
                this.agent.getBody().throwWeapon();
            }*/
        }
    }

    /**
     * @return the ready
     */
    public boolean isReady() {
        return ready;
    }

    /**
     * @param ready the ready to set
     */
    public void setReady(boolean ready) {
        this.ready = ready;
    }

    private void addItemToInventory(EItem newEItem) {
        if (collectedEItems.size() > AgentParameters.numberOfItemsInInventory) {
            throwAwayUnused();
            collectedEItems.add(newEItem);
        } else {
            collectedEItems.add(newEItem);
        }
        module.log.fine("Picked up: " + newEItem.getName() + " | affordances" + newEItem.getAffordances());
    }

    private void throwAwayUnused() {
        EItem item;
        for (int i = 0; i < collectedEItems.size();) {
            item = collectedEItems.get(i);
            if (!this.module.perceptiveField.isThingAssignedToAction(item)) {
                module.log.config("'Throwing' away " + item.name);
                collectedEItems.remove(i);
                //TODO throwing
                /*
                if (item.item instanceof AddWeapon) {
                    try {
                        agent.getBody().changeWeapon((AddWeapon) item.item);
                        wait(50);
                        agent.getBody().throwWeapon();
                    } catch (InterruptedException ex) {
                        Logger.getLogger(Inventory.class.getName()).log(Level.SEVERE, null, ex);
                    }

                }*/
            } else {
                i++;
            }
        }
    }
}
