package decisionMakingSystem;

import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import utils.TimeUtils;

/**
 * It gives an insight into the state of internal variables of DMS.
 * Displayed variables:
 * <ol>
 * <li> Actual intention and its activation
 * <li> Actual action and its activation
 * <li> Counter - number of logic iterations so far
 * <li> Time - in the format - day, hour
 * 
 * @author Ondrej
 */
class DMSModuleViewerInfo extends JPanel {
    /** a pointer to the DMS - so far to the implementation */
    private DecisionModuleImpl module = null;
    
    public DMSModuleViewerInfo(DecisionModuleImpl module) {
        if (module == null)
            throw new IllegalArgumentException("DMS is null! " + this.getClass());
        this.module = module;
        this.initComponents();
    }
    
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D) g;
        if (module == null)
            return;
        int x = 10, y = 20, yIncrement = 20;

        g2d.drawString("Plan file: \t" + module.agent.planningFilename, x, y);
        if (module.actualIntention != null) {
            y += yIncrement;
            g2d.drawString("Actual Intention: \t" + module.actualIntention.getName(), x, y);
            y += yIncrement;
            g2d.drawString("Intention activity: \t" + module.actualIntention.getActivity(), x, y);
        } else {
            y += yIncrement;
            g2d.drawString("Actual Intention: \tNone", x, y);
            y += yIncrement;
            g2d.drawString("Intention activity: \t0", x, y);
        }
        y += yIncrement;
        if (module.actualAction != null) {
            g2d.drawString("Actual Action: \t" + module.actualAction.name, x, y);
            y += yIncrement;
            g2d.drawString("Action activity: \t" + module.actualAction.activity, x, y);
        } else {
            g2d.drawString("Actual Action: \tNone", x, y);
            y += yIncrement;
            g2d.drawString("Action activity: \t0", x, y);            
        }
        y += yIncrement;
        g2d.drawString("Counter: \t\t" + module.counter, x, y);
        y += yIncrement;
        g2d.drawString("Time: \t\t" + TimeUtils.counterToDate(GMTTime.getRealTimeInTicks(module.counter)), x, y);
        
        if ((module.agent.getLocation() != null)){
            y += yIncrement;
            g2d.drawString("Location: \t\t" + module.agent.getLocation().toString(), x, y);
        }
    }
    
    private void initComponents() {
        setBackground(new java.awt.Color(255, 255, 255));
        setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        setAutoscrolls(true);
        setMaximumSize(new java.awt.Dimension(400, 300));
        setMinimumSize(new java.awt.Dimension(300, 200));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );

        getAccessibleContext().setAccessibleName("DMSViewerInfo");
        getAccessibleContext().setAccessibleDescription("Displays DMS intern variables.");    
    }
}