package decisionMakingSystem;

import java.io.Serializable;

/**
 * A central place to set some of the agent related parameters.
 * So far it gathers:
 * <ul>
 * <li> Effort coeficient - linked with the probability, that he will spot some item
 * <li> Effort attribute coeficient - as well linked with the probability, that he will spot some item
 * <li> Number of tried places in memory - maximum of places agent will visit based on the memory search
 * <li> Bias probability - bias memory to go to a place in the memory
 * <li> A bias for the amount of items bot can percieve at one moment
 * @author Ondrej
 */
public final class AgentParameters implements Serializable {
    /** number of items agent can carry at once */
    public static int numberOfItemsInInventory = 3;
    /** no clue - maybe for the probability that item will be spoted? */
    public double effortCoeficient = 0;
    /** no clue - maybe for the probability that item will be spoted?*/
    public double effortAttributeCoeficient = 0;
    /** number of places he will round during SearchMemory in Want */
    public static int numberOfTriedPlacesInMemory = 2;
    /** least necessary probability to go to the place in SearchMemory in Want */
    public static double biasProbability = 0.5;
    /** 
     * maximal number of items agent can perceive at the same time
     * means as well the maximal number elements in perceivedItems in PerceptiveField  
     */
    public static final int maxNumberOfPerceivedItems = 10;
    
    public AgentParameters() { }

    /** update the coeficients according to stress value */
    public void updateCoeficients(double stress) {
        effortCoeficient = GlobalParameters.DEFAULT_EFFORT_COEFICIENT - stress/2;
        effortAttributeCoeficient = 1 - effortCoeficient;
    }

}