/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package bot;


//import cz.cuni.amis.pogamut.base.agent.AbstractGhostAgent.AgentAct;

//import cz.cuni.amis.pogamut.base.agent.navigation.PathHandle;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutor;

//import cz.cuni.amis.pogamut.base.agent.navigation.PathNotConstructable;
//import cz.cuni.amis.pogamut.base.agent.navigation.PathPlannerListener;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;

import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
//import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTAstar;

//import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Jump;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Knight
 */
public class PathFinderModule {

   // AgentAct act; TODO: check this
    IAct act;
    //Act act;
    IVisionWorldView  worldView;
    AgentInfo agentInfo;
//    public UTAstar myPathPlanner;
    public HashMap<UnrealId, NavPoint> knownNavPoints = new HashMap<UnrealId, NavPoint>();
    /** Here we store latest path we got from GameBots */
    public ArrayList<ILocated> myPath = new ArrayList<ILocated>();
    /** True if we have already requested path to our latest goal */
    public boolean pathRequested = false;
    /** True if we have already received path to our latest goal */
    public boolean pathReceived = false;
    /** Time of our last path request */
    public double pathRequestedTime = 0;
    /** If we haven't received path in this time seconds, we will request it again */
    public int pathRerequestDelay = 3;
    /** This is navigation point closest to our goalTarget */
    public Location nearestNavLocation;
    public double lastJumpTime = 0;
    public double jumpDelay = 10;
    /**
     * We will check this in our navigation method if our path is still actual
     * if not, we will request a new path
     */
    public Location lastFollowPathLocation;
    /**
     * Current UT time.
     */
    public double currentTime;
    /**
     * For logging.
     */
    private final Logger log;
    private ArrayList<Item> itemsToRunAround = new ArrayList<Item>();
    private int currentIndexOfItem;
    static double approachRadius = 150;
    /**
     */
    IWorldEventListener<MapPointListObtained> myMapListObtainedListener = new IWorldEventListener<MapPointListObtained>() {

        public void notify(MapPointListObtained event) {
            MapPointListObtained map;

            map = (MapPointListObtained) event;
            knownNavPoints.putAll(map.getNavPoints());
        }
    };
    /**
     * Listener to Beg Message
     */
    public IWorldEventListener<BeginMessage> myBegListener = new IWorldEventListener<BeginMessage>() {

        @Override
        public void notify(BeginMessage bm) {
            currentTime = bm.getTime();
        }
    };
    /**
     * Path listener
     */
   /* public PathPlannerListener myPathListener = new PathPlannerListener() {

        @Override
        public void pathEvent(List path) {
            myPath = (ArrayList<ILocated>) path;
            pathReceived = true;
        }
    };
*/ //TODO: ask ruda where is pathplannerlistener class
    /**
     * Returns nearest navigation point to input location in the map.
     *
     * @param targetLocation
     * @return
     */
    protected Location getNearestNavLocation(Location targetLocation) {

        NavPoint result = null;

        for (NavPoint nav : knownNavPoints.values()) {
            if (result == null) {
                result = nav;
            } else {
                if (nav.getLocation().getDistance(targetLocation) < result.getLocation().getDistance(targetLocation)) {
                    result = nav;
                }
            }
        }
        return result.getLocation();
    }

    /**
     * We will run around items received from the list.
     *
     * @param newItemsToRunAround
     * @return
     */
    public boolean runAroundItemsInTheMap(ArrayList<Item> newItemsToRunAround) {

        if ((newItemsToRunAround == null) || newItemsToRunAround.isEmpty()) {
            return false;
        }

        if (itemsToRunAround.isEmpty()) {
            this.itemsToRunAround.addAll(newItemsToRunAround);
            this.currentIndexOfItem = 0;
        } else {
            if (!this.itemsToRunAround.equals(newItemsToRunAround)) {
                //restart
                this.itemsToRunAround.clear();
                this.itemsToRunAround.addAll(newItemsToRunAround);
                this.currentIndexOfItem = 0;
            }
        }

        if (currentIndexOfItem >= itemsToRunAround.size()) {
            currentIndexOfItem = 0;
        }

        if (agentInfo.atLocation(itemsToRunAround.get(currentIndexOfItem).getLocation(), approachRadius)) {
            currentIndexOfItem++;
            if (currentIndexOfItem >= itemsToRunAround.size()) {
                currentIndexOfItem = 0;
            }
        }

        goToLocation(itemsToRunAround.get(currentIndexOfItem).getLocation());
        return true;

    }

 //   PathHandle<ILocated> path = null;
//    UTAstarPathHandle path = null;

    /**
     * Goes to target location. Keeps returning true while we are on our way there.
     * If we are at location or some problem encountered, then returns false.
     *
     * @param targetLocation
     * @return
     */
    public boolean goToLocation(Location targetLocation) {
/*
        Location temp = null;

        if (agentInfo.atLocation(targetLocation, 50)) {
            //restarting
            nearestNavLocation = null;
            lastFollowPathLocation = null;
            myPath.clear();
            pathReceived = false;
            pathRequested = false;
            return false;
        }

        if (myPath.isEmpty() && !pathRequested) {
            nearestNavLocation = getNearestNavLocation(targetLocation);
            lastFollowPathLocation = agentInfo.getLocation();
            try {
            //    myPathPlanner.addPathListener(myPathListener); //TODO: uncomment this?
                pathRequestedTime = currentTime;
                path = myPathPlanner.computePath(nearestNavLocation);
                executor.followPath(path);
                pathRequested = true;
                return true;
            } catch (PathNotConstructable ex) {
                log.log(Level.SEVERE, null, ex);
                return false;
            }
        }

        //check if we should re-request the path
        if (pathRequested) {
            temp = getNearestNavLocation(targetLocation);
            if ((temp.getDistance(nearestNavLocation) > 80) || (agentInfo.getLocation().getDistance(lastFollowPathLocation) > 250)) {
                //re-request path
                nearestNavLocation = temp;
                lastFollowPathLocation = agentInfo.getLocation();
                myPath.clear();
                pathReceived = false;
                try {
                    pathRequestedTime = currentTime;
                    path = myPathPlanner.computePath(nearestNavLocation);
                    executor.followPath(path);
                } catch (PathNotConstructable ex) {
                    log.log(Level.SEVERE, null, ex);
                    return false;
                }
            }
        }

        //waiting for the path - look how long are we waiting - maybe should re-request
        if (pathRequested && !pathReceived) {
            if (currentTime - pathRequestedTime > pathRerequestDelay) {
                nearestNavLocation = getNearestNavLocation(targetLocation);
                lastFollowPathLocation = agentInfo.getLocation();
                try {
                    pathRequestedTime = currentTime;
                    path = myPathPlanner.computePath(nearestNavLocation);
                    executor.followPath(path);
                    pathRequested = true;
                    return true;
                } catch (PathNotConstructable ex) {
                    Logger.getLogger(Bot.class.getName()).log(Level.SEVERE, null, ex);
                    return false;
                }
            } else {
                return true;
            }
        }

        //if we are so close we get 0 path, we will add our target location to the path
        if (myPath.isEmpty() && pathReceived) {
            if (agentInfo.atLocation(targetLocation,250))
                myPath.add(targetLocation);
            else {
                pathRequested = false;
                pathReceived = false;
                return true;
            }
        }

        //throw out points we've been to
        if (myPath.get(0).getLocation().getDistance(agentInfo.getLocation()) < 35) {
            myPath.remove(0);
        }

        Iterator<ILocated> it = myPath.iterator();
        if (it.hasNext()) {
            Location l1 = it.next().getLocation();
            lastFollowPathLocation = agentInfo.getLocation();
            if (it.hasNext()) {
                // there are at least two points in the path
                Location l2 = it.next().getLocation();
                getAct().act(new Move().setFirstLocation(l1).setSecondLocation(l2));
                handleBotStuck();
                return true;
            } else {
                // there is only one point to go to
                getAct().act(new Move().setFirstLocation(l1));
                handleBotStuck();
                return true;
            }
        }
*/
        return false;
    }

    /**
     * Main constructor of this clas.
     *
     * @param act
     * @param worldView
     * @param agentInfo
     */
    PathFinderModule(Bot agent) {
        this.act = agent.getAct();
        this.worldView = agent.getWorldView();
        this.agentInfo = agent.agentInfo;
        this.log = agent.getLog();

        initialize(agent);
    }

    private IAct getAct() {
        return act;
    }

    //IPathExecutor<ILocated> executor = null;

    /**
     * Initialize all listeners and objects we will require.
     */
    private void initialize(Bot agent) {
  /*      myPathPlanner = new UTAstar(agent.agent);
        executor = new UTPathExecutor(agent.agent);
        getWorldView().addEventListener(MapPointListObtained.class, myMapListObtainedListener);
        getWorldView().addEventListener(BeginMessage.class, myBegListener);*/
    }

    private IWorldView getWorldView() {
        return worldView;
    }

    /**
     * Trying to handle bot stuck.
     *
     */
    private void handleBotStuck() {
        if (pathReceived && ((currentTime - pathRequestedTime) > 5)) {
            if (agentInfo.getVelocity().size() < 50) {
                if ((currentTime - lastJumpTime) > jumpDelay) {
                    this.getAct().act(new Jump());
                    lastJumpTime = currentTime;
                } else {
                    if ((currentTime - lastJumpTime) > 3) {
                        Random rnd = new Random();
                        getAct().act(new Move().setFirstLocation( agentInfo.getLocation().add(new Location((rnd.nextDouble() - 0.5) * 200,(rnd.nextDouble() - 0.5) * 200,0)) ));
                    }
                }
            }
        }
    }
}
