package bot;

import decisionMakingSystem.DMSLogger;

/**
 * An interface which defines basic functionality of an experiment controller agent will use.
 * 
 * (so far it is still agent who calls procedures not the other way around, though there is some
 * option of doing this the other way around using Drools which is an experiment control integrated
 * within Pogamut, but for the needs of those experiments we can go along without it)
 * @author Ondrej
 */
public interface ExperimentController {

  void cleanUp();

  /**
   * Called every hour to perform some other updates.
   */
  void hourUpdate();

  /**
   * Main method for the experiment control. Called daily.
   *
   * It usually performs daily update of agent and recording of the current situation.
   */
  void controlExperiment();

  /**
   * Experiment preparation - all what is needed like paths to save to, files, parameteres.
   */
  void prepareExperiment();

  FileLog getExperimentLogger();

  DMSLogger getDMSLogger();

  FileLog getExtraLogger();

  void increaseInternalCounter(double time);

  long getInternalCounter();
}