package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * Wash a floor in the place where bot is, again no direct impact on the environment
 * @author Ondrej
 */
public class WashFloor extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Wash floor finished. Duration: " + counter + " rounds");
            return true;
        }
        return true;
    }
    
    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Washing floor");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }
    
    public WashFloor (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.WASH_FLOOR;
    }

}