package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * Toilet, "Toileting" as long as the time limit says
 * @author Ondrej
 */
public class Toilet extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Toilet visited successfully. Duration: " + counter + " rounds.");
            return true;
        }
        return false;
    }
    
    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Going to the toilet.");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }
    
    public Toilet (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.TOILET;
    }

}