package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
import java.util.Random;

enum Plays {

    Hamlet,
    Othello,
    DonQuijote,
    EvgenOnegin
}

/**
 * SeeAPlay, just say he is doing it
 * @author Ondrej
 */
public class SeeAPlay extends AtomicAction implements Serializable {

    private String play;

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Seeing a play finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {

        if (counter == 0) {
            initialisation();
            agent.getLog().info("Seeing a play" + play);
        }
        counter = agent.getCurrentTime();
    }

    public SeeAPlay(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.SEE_A_PLAY;
    }

    @Override
    protected void initialisation() {
        super.initialisation();
        Random random = new Random();
        // just get a game title from the enum - just for fun:)
        play = Plays.values()[random.nextInt(Plays.values().length)].toString();
    }
}
