package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import decisionMakingSystem.Action;
import bot.Bot;
import java.io.Serializable;
/**
 * PlayUltimate, just say he is doing it
 * @author Ondrej
 */
public class PlayUltimate extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Playing frisbee finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }
    
    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("PlayUltimate");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }
    
    public PlayUltimate (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.PLAY_ULTIMATE;
    }

}