package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
import java.util.Random;

/** 
 * available Computer games title: just for varying a bit the logs
 * @author Ondrej
 */
enum ComputerGames {

    DOTA,
    TransportTycoon,
    UnrealTournament2004,
    Diablo,
}

/**
 * PlayComputerGames, just say he is doing it
 * @author Ondrej
 */
public class PlayComputerGames extends AtomicAction implements Serializable {

    String gameTitle = null;

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Playing " + gameTitle + " finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {

        if (counter == 0) {
            initialisation();
            agent.getLog().info("Computer gamesing. " + gameTitle + " now on!");
        }
        counter = agent.getCurrentTime();
    }

    @Override
    protected String getEnvironmentAction() {
        return "USE";
    }

    public PlayComputerGames(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.PLAY_COMPUTER_GAMES;
    }

    @Override
    protected void initialisation() {
        super.initialisation();
        Random random = new Random();
        // just get a game title from the enum - just for fun:)
        gameTitle = ComputerGames.values()[random.nextInt(ComputerGames.values().length)].toString();
    }
}
