package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * We are going to pub.
 * @author Ondrej
 */
public class GoToPub extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Pub reached. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Going to pub");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }

    public GoToPub (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.GO_TO_PUB;
    }

}