package atomicActions;
import bot.Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GlobalChat;
import decisionMakingSystem.Action;
import java.io.Serializable;
import javax.xml.bind.annotation.*;


/**
 * Confirms that he goes to the training -> means he goes to the computer and "sends" a message
 * on the forum to notify his team mates that he is coming to the training
 *  
 * @author Ondrej
 */
@XmlRootElement
public class ConfirmTraining extends AtomicAction implements Serializable {
    @Override
    public void execute() {        
        if (counter == 0)
            initialisation();
        counter = agent.getCurrentTime();
        this.agent.getAct().act(new SendMessage().setText("Confirm Frisbee Training").setFadeOut(8d));
        this.agent.getLog().info("Sending ConfirmTraining.");
    }
    /**
     * succeeds when message sended - can be more profound with some hand shake...
     * @return
     */
    @Override
    public boolean succeeded() {
        return true;
    }
 
    @Override
    protected String getEnvironmentAction() {
        return "USE";
    }

    @Override
    public boolean failed() {
        if ((counter - actionStart) > parent.timeLimit)
            return true;
        return false;
    }
    
    public ConfirmTraining(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.CONFIRM_TRAINING;
    }   

}
