package atomicActions;

import bot.Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * Clean floor, just say he is doing it.
 * @author Ondrej Burkert
 */
public class CleanFloor extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Cleaning floor finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {        
        if (counter == 0) {
            agent.getLog().info("Cleaningn floor");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }

    public CleanFloor (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.CLEAN_FLOOR;
    }

}