package atomicActions;


import bot.Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * BuyGroceries, just say he is doing it
 * @author Ondrej
 */
public class BuyGroceries extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Buying groceries finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Buying groceries");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }

    public BuyGroceries (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.BUY_GROCERIES;
    }

}