package utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 * Gives a real time (in the real world) which is used to date records in logs of experiments.
 *
 * @author Ondrej Burkert
 */
public final class DateUtils {

    private static String now(String dateFormat) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(cal.getTime());
    }

    public static String nowHours() {
        return now("h:mm a");
    }

}