package decisionMakingSystem;

import utils.TimeUtils;

/**
 * holds all parameters for all agents - so its not necessary to change them everywhere
 * singleton!
 * 
 * @author Ondrej
 */
public class GlobalParameters {
    /** how long does an item hold in perceptive field without usage */
    public static int FADEOUT_FOR_ITEMS = 20;
    /** how long does an action hold in preactive state before discarding */
    public static int FADEOUT_FOR_ACTIONS = 25;
    /** how long does an intention hold in preactive state before discarding */
    public static int FADEOUT_FOR_INTENTIONS = 30;
    /**  */
    public static double DEFAULT_EFFORT_COEFICIENT = 0.8;
    
    /** 
     * number of logic iterations which defines a day 
     * WARNING used a lot a lot a lot!!! and should be at least one tick = one minute.
     * what we will try then will be one tick = 3 seconds => that will take ages to simulate a year though;) 
     * (minutes per day = 1440 => 28 800 will go for 3 seconds per tick)
     */
    public static int LENGHT_OF_A_DAY = 1440; //1440 = 1 minute = 1 second; 1 tick = 30 seconds  => 2880, 1 tick = 10 sec => 8640
    /** number of minutes of search random before it times out*/
    public static int SEARCH_RANDOM_LENGHT = 15;
    
    private static GlobalParameters instance = null;
    
    public static GlobalParameters getInstance() {
        if (instance == null) {
            instance = new GlobalParameters();
            instance.GlobalParametersRecount();
        }
        return instance;
    }
    
    public void GlobalParametersRecount() {
        //HACK: this is a hack, because item fadeouts are still handled by ticks of logic. :-/
        FADEOUT_FOR_ITEMS = TimeUtils.minutesToTicksOfLogic(FADEOUT_FOR_ITEMS) * 5;
        FADEOUT_FOR_ACTIONS = TimeUtils.minutesToTicksOfLogic(FADEOUT_FOR_ACTIONS);
        FADEOUT_FOR_INTENTIONS = TimeUtils.minutesToTicksOfLogic(FADEOUT_FOR_INTENTIONS);
        SEARCH_RANDOM_LENGHT = TimeUtils.minutesToTicksOfLogic(SEARCH_RANDOM_LENGHT);
    }
    
    protected GlobalParameters() {}
    
}