package decisionMakingSystem;

import atomicActions.AtomicAction;
import bot.DMSMemoryVO;
import utils.Interval;
/**
 * Defines the interface which decision module gives to other modules around (like memory, agent).
 * @author Ondrej
 */
public interface DecisionModule {
    /**
     * @return Action performed at the moment.
     */
    public Action getActualAction();
    /**
     * Does reasoning - in the end executes some atomic action.
     * @return value object with some basic info about the last iteration.
     */
    public DMSMemoryVO doReasoning(int time);
    /**
     * @return Intention in progress
     */
    public Intention getActualIntention();
    /**
     * @return counter - e.g. ticks of logic from the beginning of the simulation.
     */
    public int getCounter();
    /**
     * @return Actual atomic action which is being executed.
     */
    public AtomicAction getActualAtomicAction();
    /**
     * @return GMT time - e.g. the difference between the timezones of agent's origin and agent's current location.
     */
    public double getGMTTime();
    /**
     * @return old atomic action - atomic action performed before the change to a next one. (set only for one tick of logic)
     */
    public AtomicAction getOldAtomicAction();
    /**
     * Allows external modules to introduce a new intention to the plan.
     * Inserted intention's name must be among the names available to the agent.
     * 
     * @param name - name of the intention (e.g. IEat)
     * @param actInterval - activation interval of the new intention
     */
    public void addIntention(String name, Interval actInterval);
}