package bot;

//import com.csvreader.CsvWriter;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
//import cz.cuni.amis.pogamut.base.communication.connection.socket.SocketConnectionAddress;
import cz.cuni.amis.utils.exception.PogamutException;
//import cz.cuni.amis.pogamut.base.exceptions.PogamutRuntimeException;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
//import cz.cuni.amis.pogamut.base.perception.IPerception;
//import cz.cuni.amis.pogamut.base.perception.feature.IFeaturesExtractor;
//import cz.cuni.amis.pogamut.base.perception.feature.MemoryFeatureStorage; TODO: ask where is this class
//import cz.cuni.amis.pogamut.base.perception.hammurapi.HammurapiPerception;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
//import cz.cuni.amis.pogamut.ut2004.bot.SyncUT2004Bot;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;

//import cz.cuni.amis.pogamut.ut2004.factory.guice.UTGuiceSyncFactory;
import decisionMakingSystem.DecisionModuleImpl;

import decisionMakingSystem.DMSModuleViewer;
import decisionMakingSystem.EItem;
import decisionMakingSystem.GMTTime;
import decisionMakingSystem.GlobalParameters;
import decisionMakingSystem.ItemMemory;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import utils.TimeUtils;
import java.io.File;


import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType.Category;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import pogamutEndEvent.IPogamutEndEventListener;
import pogamutEndEvent.PogamutEndEventType;

/**
 * Pogamut's "Hello world!" example showing few extra things such as introspection
 * and various bot-initializing methods.
 *
 * @author Michal Bida aka Knight
 * @author Rudolf Kadlec aka ik
 * @author Jakub Gemrot aka Jimmy
 */
@AgentScoped
public class Bot extends UT2004BotModuleController {

    UT2004Bot agent;
    private static IPogamutEndEventListener listener = null;

    public void setPogamutEndEventListener(IPogamutEndEventListener _listener) {
        listener = _listener;
    }

    @Override
    public IVisionWorldView getWorldView() {
        return super.getWorldView();
    }
    public boolean verbose; // to enable some special extra super logging when necessary:)
    public double gmtTime = 0.0;
    private double oldGMT = 0.0;
    private boolean loadAgentFromFile = false;
    private ExperimentController expControl;
    /** decision making module */
    private DecisionModuleImpl decisions = null;
    public Game game;
    public AgentInfo agentInfo;
    public Players players;
    private DMSMemoryVO memoryVO = null;
    /** visualizers, viewers */
    private DMSModuleViewer dmsViz;
    private ArrayList<Item> knownWeapons = new ArrayList<Item>();
    private ArrayList<Item> knownItems = new ArrayList<Item>();
    public String mapMarkings = "maps" + File.separator + "UnrealVille.xml";//"config\\ScenarioMap.xml"
    String directory = "." + File.separator;
    public String planningFilename = "transitions" + File.separator + "Student.xml";
    //public String planningFilename = "config\\StudentFix.xml";
    private Initialize initilizeCommand = null;
    public int lifeTime = 24; //how many days our agent will live
    //DETERIMINE IS DMS WINDOW IS DISPLAYED
    public static boolean noFrames = true;
    PathFinderModule myPathFinder;
    public HashMap<UnrealId, NavPoint> knownNavPoints = new HashMap<UnrealId, NavPoint>();
    public double currentTime;
    protected double lastFeaturesTime = 0;
    protected static final double FEATURES_INTERVAL = 3;
    public ItemMemory itemMemory;
    private int currentItemIndex = 0;
    public static double TMP_TimeSpeed = 1; //mikajel: temporary variables used for adjusting environment time
    public static double TMP_TimeStart = -1;
    private double TMP_TimeDiff = -1;
    private double TMP_TimeOrigStart = -1;

    /*  private MemoryFeatureStorage perceptionFeatureStorage;
    private MemoryFeatureStorage introspectionFeatureStorage;
    private MemoryFeatureStorage intentionFeaturesStorage;
    private String featuresFilename = "features.ser";
    private String introspectFeaturesFilename = "introspectFeatures.ser";
    private String intentionFeaturesFilename = "intentionFeatures.ser";
    private CsvWriter introspectionWriter = new CsvWriter("introspectData.csv");
     */ //TODO: had to comment this out
    IWorldEventListener<MapPointListObtained> myMapListObtainedListener = new IWorldEventListener<MapPointListObtained>() {

        public void notify(MapPointListObtained event) {
            MapPointListObtained map;

            map = (MapPointListObtained) event;
            knownNavPoints.putAll(map.getNavPoints());

            for (NavPoint nav : knownNavPoints.values()) {
                EItem eItem = decisions.things.processItem(nav);
                if (eItem != null) {
                    itemMemory.addItemToMemory(eItem, 0, 1);
                }
            }
        }
    };
    /**
     * Listener to Beg Message
     */
    public IWorldEventListener<BeginMessage> myBegListener = new IWorldEventListener<BeginMessage>() {

        @Override
        public void notify(BeginMessage bm) {
            currentTime = bm.getTime();

            //Mikajel: testing stuff - used to adjust environment time
            if (TMP_TimeOrigStart == -1) {
                TMP_TimeOrigStart = currentTime;
            }
            TMP_TimeDiff = currentTime - TMP_TimeOrigStart;
            currentTime = TMP_TimeStart + (currentTime - TMP_TimeOrigStart) * TMP_TimeSpeed;
            //   currentTime = 10050 + TMP_TimeDiff;
            //10000 = 22:40; 10060 = 23:40;
        }
    };

    /**
     * Main method that controls the bot - makes decisions what to do next.
     * It is called iteratively by Pogamut engine every time a synchronous batch
     * from the environment is received. This is usually 4 times per second - it
     * is affected by visionTime variable, that can be adjusted in GameBots ini file in
     * UT2004/System folder.
     *
     * @throws cz.cuni.amis.pogamut.base.exceptions.PogamutException
     */
    public DecisionModuleImpl getDecisions() {
        return decisions;
    }

    @Override
    public void logic() throws PogamutException {
        expControl.increaseInternalCounter(currentTime);
        //      currentTime++;

        doNormalActions();

        if (GMTTime.isMidnight((int) (expControl.getInternalCounter()))) {      // - explorationPeriod))) {
            getLog().fine("Midnight update Main.java");
            expControl.controlExperiment();
        }


    }

    protected void doAction(String act) {
        try {
            getAct().act(new Configuration().setAction("USE"));
            Self slf = getWorldView().getSingle(Self.class);
            Field f = Self.class.getDeclaredField("action");
            f.setAccessible(true);
            f.set(slf, act);
        } catch (Exception ex) {
            throw new PogamutException("Reflect exception.", ex, this);
        }
    }
    protected static final String PERC_LOG = "PERC";

    private void doNormalActions() {
        memoryVO = decisions.doReasoning(getCurrentTime());

        memoryVO.setVerbose(verbose);
        if (oldGMT != gmtTime) {
            decisions.setGMT(gmtTime);
            expControl.getDMSLogger().writeAMessage("Time zone changed! Change: " + gmtTime + "\n\r");
            memoryVO.setGMTChanged(true);
            oldGMT = gmtTime;
        }

        expControl.getDMSLogger().update(memoryVO);

        if (!noFrames) {
            dmsViz.update();

            if (memoryVO.getCounter() % (GlobalParameters.LENGHT_OF_A_DAY / 24) == 0) {
            }
        }
        if (TimeUtils.isHour(decisions.counter)) {
            expControl.hourUpdate();
        }
    }

    /**
     * Initialize all necessary variables here, before the bot actually receives anything
     * from the environment.
     */
    @Override
    public void prepareBot(UT2004Bot bot) {

        this.game = new Game(bot, this.getLog());
        this.agentInfo = new AgentInfo(bot, game, this.getLog());
        this.players = new Players(bot, this.getLog());

        itemMemory = new ItemMemory(getLog());
        getWorldView().addEventListener(MapPointListObtained.class, myMapListObtainedListener);
        getWorldView().addEventListener(BeginMessage.class, myBegListener);
        //myPathFinder = new PathFinderModule(this);

        //logicFrequency = 14;

        prepareNewAgent();

        if (noFrames) {
        } else {
            dmsViz = new DMSModuleViewer(decisions);
        }


        this.getLog().info("finished with preparation.");
        getLog().setLevel(Level.SEVERE);
        //   getLog().platform().setLevel(Level.SEVERE);
        //   getLog().in().setLevel(Level.SEVERE);
        //   getLog().out().setLevel(Level.SEVERE);

    }

    private void setNextWeaponTarget() {
        currentItemIndex++;
        if (knownWeapons.size() == currentItemIndex) {
            currentItemIndex = 0;
        }
        //pathExecutor.goTo(knownWeapons.get(currentItemIndex));
    }

    private void prepareNewAgent() {
        //conMemory = new MemoryImpl(getLogger().user(), directory);

        decisions = new DecisionModuleImpl(itemMemory);
        decisions.prepareLogic(this, directory, planningFilename);
        if (listener != null) {
            decisions.eventSource.addEventListener(listener);
        }
        expControl = new ExperimentControllerImpl(getLog(), directory, this);
        expControl.prepareExperiment();
        decisions.setDMSLogger(expControl.getDMSLogger());
        decisions.eventSource.fireEvent(PogamutEndEventType.INIT_DECISION_TREE, decisions.allIntentions);
    }

    /**
     * Handshake with GameBots2004 is over - bot has information about the map in its world view.
     * Many agent modules are usable since this method is called.
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     */
    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        // This is taken from postPrepareBot
        //TODO: find all weapons in the map
        //weaponsToRunAround = getMemory().getKnownWeapons();
        /** List of all navpoints in the map - got from MapListObtainedEvent */
        knownItems.addAll(getWorldView().getAll(Item.class).values());
        knownWeapons.addAll(getWorldView().getAll(Item.class).values());

        for (Item it : knownItems) {
            EItem eItem = decisions.things.processItem(it);
            if (eItem != null) {
                itemMemory.addItemToMemory(eItem, 0, 1);
            }
        }

        Iterator<Item> iterator = knownWeapons.iterator();
        Item it;
        while (iterator.hasNext()) {
            it = iterator.next();
            if (it.getType().getCategory() != Category.WEAPON) {
                iterator.remove();
            }
        }
    }

//    IFeaturesExtractor featuresExtractor;
    //   IPerception perception;
    protected void shutdownAgent() {
        // Clean up after the end of simulation of agent
        expControl.cleanUp();
        if (!noFrames) {
            dmsViz.dispose();
        }

    }

    /**
     * The bot is initilized in the environment - a physical representation of the bot is present in the game.
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     * @param self information about the agent
     */
    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        // Display a welcome message in the game engine
        body.getCommunication().sendGlobalTextMessage("Hello world! I am alive!");
    }

    private void runAroundTheMap() {
        runAroundItemsInTheMap(knownWeapons, false);
    }

    DecisionModuleImpl getDMS() {
        return decisions;
    }

    /**
     * Called each time the bot dies. Good for reseting all bot's state dependent variables.
     *
     * @param event
     */
    @Override
    public void botKilled(BotKilled event) {
    }

    /**
     * Here we can modify initializing command for our bot, e.g., sets its name or skin.
     * @return instance of {@link Initialize}
     */
    @Override
    public Initialize getInitializeCommand() {
        if (this.initilizeCommand == null) {
            return new Initialize();
        } else {
            return this.initilizeCommand;
        }
        //     return new Initialize().setName("MyBotInitialized");
    }
    ICommandListener moveListener;

    public Bot() {
        super();

        //  getLog().getCategoryName(PERC_LOG);
/*        getAct().addCommandListener(Move.class, moveListener = new ICommandListener<CommandMessage>() {

        public void notify(CommandMessage event) {
        if(event instanceof Move) {
        getAct().act(new Configuration().setAction("WALK"));
        }
        }
        });*/
    }

    public void runAroundItemsInTheMap(ArrayList<Item> itemsToRunAround, boolean b) {
//        myPathFinder.runAroundItemsInTheMap(itemsToRunAround);
    }

    public ArrayList<Item> getKnownWeapons() {
        //return all weapons we know
        return knownWeapons;
    }

    public Object getSeeItem(long id) {
        //return something if we see item null othervise

        for (Item it : knownItems) {
            Long longId = getDecisions().things.idTable.get(it.getId());
            if (longId == null) {
                Long newId = (long) getDecisions().things.idTable.size() + 1;
                getDecisions().things.idTable.put(it.getId(), newId);
                longId = newId;
            }
            if (longId == id) {
                //  if (it.getId().getLongId() == id) {
                if (it.isVisible()) {
                    return it;
                }
            }
            /*                      Long longId = idTable.get(item.getId());
            if (longId == null) {
            Long newId = (long)idTable.size() + 1;
            idTable.put(item.getId(), newId);
            longId = newId;
            }*/
        }

        return null;
    }

    public void safeRunToLocation(Location location) {
        IPathFuture<ILocated> pathHandle = pathPlanner.computePath(info.getLocation(), location);
        // make the path executor follow the path, executor listens for the
        // asynchronous result of path planning
        pathExecutor.followPath(pathHandle);
    }

    public int getCurrentTime() {
        return (int) Math.round(currentTime);
    }

    public Location getLocation() {
        Self self = getWorldView().getSingle(Self.class);
        if (self != null) {
            return self.getLocation();
        }
        return null;
    }

    public void createAgent() {
        new UT2004BotRunner(Bot.class, "MyBot").setMain(true).startAgent(); //{
/* TODO
        @Override
        protected void postStartHook(UT2004Bot agent) throws PogamutException {
        super.postStartHook(agent);
        }

         */
        //}.startAgent();
        //   }
    }

    @Override
    public void initializeController(UT2004Bot bot) {
        super.initializeController(bot);
        agent = bot;
    }

    public static void main(String args[]) throws PogamutException {
        // wrapped logic for bots executiona, suitable to run single bot in single JVM
        //new SingleUT2004BotRunner<UT2004Bot>(Bot.class, "EmptyBot").startAgent();
        new UT2004BotRunner(Bot.class, "MyBot").startAgent();
        //createAgent();
    }
}
