package bot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * The action manager executes actions (see InterfacePerform) which can be added, removed.
 *
 * There are two lists - actions which are supposed to be executed every hour
 * and actions which should be executed every day (each midnight).
 *
 * @author Ondrej Burkert
 */
class ActionManager implements Serializable {

  private List<InterfacePerform> everyHourActions;
  private List<InterfacePerform> everyDayActions;

  public ActionManager() {
    everyHourActions = new ArrayList<InterfacePerform>();
    everyDayActions = new ArrayList<InterfacePerform>();
  }

  public void doEveryHourActions(String path, int day, int hour) {
    for (InterfacePerform perform : everyHourActions) {
      perform.perform(path, day, hour);
    }
  }

  public void doEveryDayActions(int day) {
    for (InterfacePerform perform : everyDayActions) {
      perform.perform(day);
    }
  }

  public void addHourAction(InterfacePerform perform) {
    everyHourActions.add(perform);
  }

  public void addDayAction(InterfacePerform perform) {
    everyDayActions.add(perform);
  }

  public void removeDayAction(Actions action) {
    for (int i = 0; i < everyDayActions.size();) {
      if (everyDayActions.get(i).identification().equals(action)) {
        everyDayActions.remove(everyDayActions.get(i));
      } else {
        i++;
      }
    }
  }

  public void removeHourAction(Actions action) {
    for (int i = 0; i < everyHourActions.size();) {
      if (everyHourActions.get(i).identification().equals(action)) {
        everyHourActions.remove(everyHourActions.get(i));
      } else {
        i++;
      }
    }
  }

  void cleanUp() {
    for (InterfacePerform perform : everyHourActions) {
      perform.cleanUp();
    }
    for (InterfacePerform perform : everyDayActions) {
      perform.cleanUp();
    }

  }
}