package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
import java.util.Random;

enum Series {
    HowIMetYourMother,
    KyleXY,
    BattlestarGalactica,
    ITCrowd,
    BigBangTheory,
    Lost,
    Futurama,
    Friends
}

/**
 * StareAtTV, just say he is doing it
 * @author Ondrej
 */
public class StareAtTV extends AtomicAction implements Serializable {
    private String title;

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Staring at TV finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            initialisation();
            agent.getLog().info("Staring at TV. Series: " + title);
        }
        counter = agent.getCurrentTime();
    }

    public StareAtTV (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.STARE_AT_TV;
    }

    @Override
    protected void initialisation() {
        super.initialisation();
        Random random = new Random();
        // just get a game title from the enum - just for fun:)
        title = Series.values()[random.nextInt(Series.values().length)].toString();
    }

}