package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * SellGroceries, just say he is doing it
 * @author Ondrej
 */
public class SellGroceries extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Selling groceries finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Selling groceries");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }

    public SellGroceries (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.SELL_GROCERIES;
    }

}