package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import bot.Bot;
import decisionMakingSystem.Action;
import java.io.Serializable;
import java.util.Random;

enum Movies {
    Australia,
    Indentity,
    Next,
    Gattaca,
}

/**
 * Seeing a movie, just say he is doing it
 * @author Ondrej
 */
public class SeeAMovie extends AtomicAction implements Serializable {

    private String movie;

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("SeeAMovieing finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {

        if (counter == 0) {
            initialisation();
            agent.getLog().info("Seeing a movie: " + movie);
        }
        counter = agent.getCurrentTime();
    }

    public SeeAMovie(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.SEE_A_MOVIE;
    }

    @Override
    protected void initialisation() {
        super.initialisation();
        Random random = new Random();
        // just get a game title from the enum - just for fun:)
        movie = Movies.values()[random.nextInt(Movies.values().length)].toString();
    }
}