package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import decisionMakingSystem.Action;
import bot.Bot;
import java.io.Serializable;
import javax.xml.bind.annotation.*;

/**
 * ending the session with a commandable bot releasing him free
 * @author Ondrej
 */
@XmlRootElement
public class SayGoodBye extends AtomicAction implements Serializable {

    @Override
    public void execute() {
        this.agent.getLog().info("Saying good bye after the game.");
        

        this.agent.getAct().act(new SendMessage().setText("END OF THE GAME"));
    }

    @Override
    public boolean succeeded() {
        return true;
    }
    
    @Override
    public boolean failed() {
        return false;
    }

    public SayGoodBye(Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.SAY_GOOD_BYE;
    }

}

