package atomicActions;

import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;

import decisionMakingSystem.Action;
import bot.Bot;
import java.io.Serializable;
/**
 * Read, just say he is doing it
 * @author Ondrej
 */
public class Read extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Reading finished. Duration: " + counter + " rounds");
            return true;
        }
        return false;
    }
    
    @Override
    public boolean failed() {
        return false;
    }

    
    @Override
    public void execute() {
                
        if (counter == 0) {
            agent.getLog().info("Reading");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }
    
    public Read (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.READ;
    }

}