package atomicActions;

import bot.Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;

import decisionMakingSystem.Action;
import java.io.Serializable;
/**
 * cook, just say he is doing it
 * @author Ondrej
 */
public class Cook extends AtomicAction implements Serializable {

    @Override
    public boolean succeeded() {
        if ((counter - actionStart) > parent.timeLimit) {
            logFinished("Cooking finished. Duration: " + counter + " rounds");
            agent.getAct().act(new Configuration().setAction("NONE"));
            return true;
        }
        return false;
    }

    @Override
    protected String getEnvironmentAction() {
        return "USE";
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public void execute() {
        
        if (counter == 0) {
            agent.getLog().info("Cooking");
            initialisation();
        }
        counter = agent.getCurrentTime();
    }
    
    public Cook (Action parent, Bot agent) {
        super(parent, agent);
        this.type = AtomicActions.COOK;
    }

    @Override
    protected void initialisation() {
        this.agent.getAct().act(new Configuration().setAction(this.type.toString()).setName(this.type.toString()));
        actionStart = agent.getCurrentTime();
    }
    
}