package atomicActions;

import atomicActions.basic.Eat;
import atomicActions.basic.Take;
import atomicActions.basic.Use;
import atomicActions.basic.Walk;
import bot.Bot;
import decisionMakingSystem.Action;

/**
 * Atomic action factory produces offsprings of AtomicAction based on their types.
 * It includes just a big switch on their types and returns objects of proper types.
 * It is of course a singleton.
 * @author Ondrej
 */
public final class AtomicActionFactory {

  /**
   * thread safe variant of initializing the factory:)
   */
  private static final AtomicActionFactory factory = new AtomicActionFactory();

  public static AtomicActionFactory getInstace() {
    return factory;
  }

  private AtomicActionFactory() {
  }

  public AtomicAction getAction(AtomicActions type, Action parent, Bot agent) {
    AtomicAction act = new AtomicAction(type);
    switch (type) {
      case SLEEP:
        act = new Sleep(parent, agent);
        break;
      case SAY_HELLO:
        act = new SayHello(parent, agent);
        break;
      case WASH_FOOD:
        act = new WashFood(parent, agent);
        break;
      case COOK:
        act = new Cook(parent, agent);
        break;
      case FOLLOW:
        act = new Follow(parent, agent);
        break;
      case PLAY_COMPUTER_GAMES:
        act = new PlayComputerGames(parent, agent);
        break;
      case PLAY_BOARD_GAMES:
        act = new PlayBoardGames(parent, agent);
        break;
      case READ:
        act = new Read(parent, agent);
        break;
      case USE_WIKIPEDIA:
        act = new UseWikipedia(parent, agent);
        break;
      case RUN:
        act = new Run(parent, agent);
        break;
      case SAY_GOOD_BYE:
        act = new SayGoodBye(parent, agent);
        break;
      case JUMP:
        act = new Jump(parent, agent);
        break;
      case CONFIRM_TRAINING:
        act = new ConfirmTraining(parent, agent);
        break;
      case PLAY_ULTIMATE:
        act = new PlayUltimate(parent, agent);
        break;
      case SWIM:
        act = new Swim(parent, agent);
        break;
      case WASH_FLOOR:
        act = new WashFloor(parent, agent);
        break;
      case BRUSH_TEETH:
        act = new BrushTeeth(parent, agent);
        break;
      case WASH_FACE:
        act = new WashFace(parent, agent);
        break;
      case SIT_AT_THE_LECTURE:
        act = new SitAtTheLecture(parent, agent);
        break;
      case TOILET:
        act = new Toilet(parent, agent);
        break;
      case SHOWER:
        act = new Shower(parent, agent);
        break;
      case EAT:
        act = new Eat(parent, agent);
        break;
      case DRINK:
        act = new Drink(parent, agent);
        break;
      case SHOP:
        act = new Shop(parent, agent);
        break;
      case WORK:
        act = new Work(parent, agent);
        break;
      case SEE_A_MOVIE:
        act = new SeeAMovie(parent, agent);
        break;
      case SEE_A_PLAY:
        act = new SeeAPlay(parent, agent);
        break;
      case SEE_EXHIBITION:
        act = new SeeExhibition(parent, agent);
        break;
      case STARE_AT_TV:
        act = new StareAtTV(parent, agent);
        break;
      case CLEAN_FLOOR:
        act = new CleanFloor(parent, agent);
        break;
      case SELL_GROCERIES:
        act = new SellGroceries(parent, agent);
        break;
      case BUY_GROCERIES:
        act = new BuyGroceries(parent, agent);
        break;
      case PREPARE_GAME:
        act = new PrepareAGame(parent, agent);
        break;
      case EXPLAIN_GAME:
        act = new ExplainRules(parent, agent);
        break;
      case GO_TO_PUB:
        act = new GoToPub(parent, agent);
        break;
      case JOIN_SOMEONE_DRINKING:
        act = new JoinSomeoneDrinking(parent, agent);
        break;
      case PROGRAM:
        act = new Program(parent, agent);
        break;
      case TAKE:
        act = new Take(parent, agent);
        break;
      case USE:
        act = new Use(parent, agent);
        break;
      case WALK:
        act = new Walk(parent, agent);
        break;
      case BAKE:
        act = new Bake(parent, agent);
        break;
      case BORROW:
        act = new Borrow(parent, agent);
        break;
      case CLEAN:
        act = new Clean(parent, agent);
        break;
      case CROCHET:
        act = new Crochet(parent, agent);
        break;
      case CYCLE:
        act = new Cycle(parent, agent);
        break;
      case DANCE:
        act = new Dance(parent, agent);
        break;
      case DIG:
        act = new Dig(parent, agent);
        break;
      case DRESS_UP:
        act = new DressUp(parent, agent);
        break;
      case EMBROIDER:
        act = new Embroider(parent, agent);
        break;
      case EXCERCISE:
        act = new Excercise(parent, agent);
        break;
      case FIX:
        act = new Fix(parent, agent);
        break;
      case KNIT:
        act = new Knit(parent, agent);
        break;
      case LISTEN:
        act = new Listen(parent, agent);
        break;
      case PAINT:
        act = new Paint(parent, agent);
        break;
      case PAY:
        act = new Pay(parent, agent);
        break;
      case PLANT:
        act = new Plant(parent, agent);
        break;
      case PREPARE:
        act = new Prepare(parent, agent);
        break;
      case SHUT_DOWN:
        act = new ShutDown(parent, agent);
        break;
      case SING:
        act = new Sing(parent, agent);
        break;
      case START:
        act = new Start(parent, agent);
        break;
      case TAKE_OUT_GARBAGE:
        act = new TakeOutGarbage(parent, agent);
        break;
      case THINK:
        act = new Think(parent, agent);
        break;
      case WAIT:
        act = new Wait(parent, agent);
        break;
      case WANDER_AROUND:
        act = new WanderAround(parent, agent);
        break;

      default:
        agent.getLog().warning("Unimplemented type: " + type); // maybe propagate to fail
    }
    return act;
  }
}