/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.episodic.launcher;

import bot.Bot;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import cz.cuni.amis.pogamut.episodic.query.QueryModule;
import cz.cuni.amis.pogamut.episodic.visualizer.VisualizationCreator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import pogamutEndEvent.PogamutEndEvent;
import pogamutEndEvent.PogamutEndEventType;
import com.thoughtworks.xstream.XStream;
import java.util.Collections;
import java.util.Random;
import pogamutEndEvent.PogamutEndAffordanceUsed;


/**
 *
 * @author Administrator
 */
public class Launcher {
    static String readFrom = null;
    static String evtFrom = null;
    static String logEventsTo = null;
    static boolean saveMemory = false;
    static String saveFile = null;
    static ArrayList<Integer> saveTime = new ArrayList<Integer>();
    static int startTime = 0;
    static public int statsTime = 0;
    static public String statsFile = null;

    private static AgentMemory readMemory(String fileName) {
        try {
            FileInputStream in = new FileInputStream(fileName);
            ObjectInputStream s2 = new ObjectInputStream(in);

            AgentMemory mem = (AgentMemory)s2.readObject();
            //TODO: check decision tree compatibility
            
            mem.sem.release();

            return mem;
        } catch (IOException ex) {
            System.out.println("Exception in readMemory: " + ex.getMessage());
        } catch (ClassNotFoundException ex2) {
            System.out.println("Exception in readMemory: " + ex2.getMessage());
        }
        return null;
    }

    private static void parseCommandLine(String args[]) {
        int i = 0, j;
        String arg;

        while (i < args.length && args[i].startsWith("-")) {
            arg = args[i++];

            if (arg.equals("-readFrom")) {
                if (i < args.length)
                    readFrom = args[i++];
                else
                    System.err.println("-readFrom requires a filename");
            }
            else if(arg.equals("-startTime")) {
                if (i < args.length)
                    try {
                        startTime = Integer.parseInt(args[i++]);
                    } catch (Exception e) {
                        System.err.println(e.toString());
                        System.err.println("Could not parse startTime parameter!");
                    }
                else
                    System.err.println("-startTime requires a parameter");
            }
            else if(arg.equals("-evtFrom")) {
                if (i < args.length)
                    evtFrom = args[i++];
                else
                    System.err.println("-evtFrom requires a filename");
            }
            else if(arg.equals("-logEvtTo")) {
                if (i < args.length)
                    logEventsTo = args[i++];
                else
                    System.err.println("-logEvtTo requires a filename");
            }
            else if(arg.equals("-statTime")) {
                if (i < args.length)
                    try {
                        statsTime = Integer.parseInt(args[i++]);
                    } catch (Exception e) {
                        System.err.println(e.toString());
                        System.err.println("Could not parse statTime parameter!");
                    }
                else
                    System.err.println("-statTime requires a parameter");            
            }
            else if(arg.equals("-statFile")) {
                if (i < args.length)
                    statsFile = args[i++];
                else
                    System.err.println("-statsFile requires a filename");
            }
            else if(arg.equals("-saveFile")) {
                if (i < args.length)
                    saveFile = args[i++];
                else
                    System.err.println("-saveFile requires a filename");
            }
            else if(arg.equals("-saveTime")) {
                if (i < args.length) {
                    int parsed;
                    try {
                        while (true) {
                            parsed = Integer.parseInt(args[i]);
                            saveMemory = true;
                            i++;
                            saveTime.add(parsed);
                        }
                    } catch (Exception e) {
                        if (!saveMemory) {
                            System.err.println(e.toString());
                            System.err.println("Could not parse statTime parameter!");
                        }
                    }
                }
                else
                    System.err.println("-saveTime requires a parameter");
            }
        }
        if (saveMemory && (saveFile == null || saveTime.isEmpty())) {
            saveMemory = false;
        }
    }

    public static void main(String args[]) {

        AgentMemory.visualize = true;

        AgentMemory mem = new AgentMemory();
        
   //     saveMemory = true;
   //     saveFile = "D:\\Desktop\\D stuff\\mems\\saved\\t";
   //     readFrom = "D:\\Desktop\\D stuff\\mems\\saved\\t12965.mem";
        //IF STARTTIME > 0, INIT DTREE WILL NOT BE LOADED FROM EVT FILE
   //     startTime = 12965;
   //     statsFile = "D:\\Desktop\\D stuff\\stats.txt";
   //     statsTime = 23*24*60-5;
   //     evtFrom = "D:\\Desktop\\D stuff\\mems\\evtFile - 24 days";
   //     evtFrom = "D:\\Desktop\\observeEvents";
   //     logEventsTo = "D:\\Desktop\\D stuff\\mems\\evtFile";
   //     Parameters.NO_EPISODE_MERGING = true;
   //     Parameters.NO_ABSTRACT_CHRONOBAGS = true;
   //     Parameters.NO_FORGETTING = true;
   //     Parameters.REMEMBER_SEEN_ITEMS = true;

      //  generateEvents(25, 1, evtFrom, "D:\\Desktop\\observeEvents");
      //  generateEvents(3, 10, "D:\\Desktop\\mems\\evtFile", "D:\\Desktop\\mems\\evtFile2");

        /*
         * If the value of readFrom is not null, the program will try to load
         * memory content from the path specified in it (assuming memory contents
         * were saved to it before). If the value is null, the agent will start
         * with empty memory.
         */
     //   readFrom = "D:\\Desktop\\4380.txt";

        if (readFrom != null) {
            mem = readMemory(readFrom);
        }

        new QueryModule(mem);

        VisualizationCreator viz = new VisualizationCreator();
   //     VisualizationCreator viz2 = new VisualizationCreator();
        mem.addVisualizationListener(viz);
   //     mem.addEventListener(viz2);
        mem.initVisualizers();

      /*      System.out.println("snodes" + mem.getSchemaBag().getNumberOfNodes());
            int n = 0;
            Chronobag c = mem.getPresentChronobag();
            while (c != null) {
                n += c.getNumberOfEpisodeNodes();
                c = c.getOlderChronobag();
            }
            System.out.println("enodes" + n);
            //System.out.println("snodes" + mem.getSchemaBag().g);
       
       */

        PogamutEndEventListener listener = new PogamutEndEventListener(mem);
    /*
     * if listener.saveTime is set the memory will be saved to disk
     * after the time exceeds the given value. This is just temporary
     * solution so the path in PogamutEndEventListenter.saveMemory
     * (the method that saves the memory content) is hardcoded. You
     * will need to change it.
     */
        if (saveMemory) {
            for (int i = 0; i < 28; i++) {
                listener.saveTime.add(i*24*60 + 0*60 + 5);
                listener.saveTime.add(i*24*60 + 23*60 + 55);
            }
            listener.saveFile = saveFile;
        }
        
        listener.statsFile = statsFile;
        listener.statsTime = statsTime;

        if (evtFrom != null) {
            try {
                FileInputStream evtLog = new FileInputStream(evtFrom);
                ObjectInputStream evtStream = new ObjectInputStream(evtLog);

                PogamutEndEvent evt = null;
                boolean passedStartTime = false;
                if (startTime == 0) {
                    passedStartTime = true;
                }
                while (true) {
                        evt = (PogamutEndEvent) evtStream.readObject();
                        if (evt.time > startTime) {
                            passedStartTime = true;
                        }
                        if (!passedStartTime) continue;
                        listener.handlePogamutEndEvent(evt);
                }
            } catch (FileNotFoundException e) {
                System.err.println(e);
            } catch (IOException e) {
                System.err.println(e);
            } catch (ClassNotFoundException e) {
                System.err.println(e);
            }
        } else {
            listener.logEventsTo = logEventsTo;

            Bot myBot = new Bot();
            //Bot.noFrames = true;
            Bot.noFrames = false;

            myBot.setPogamutEndEventListener(listener);
            Bot.TMP_TimeSpeed = 1;
            Bot.TMP_TimeStart = startTime;
            //Bot.TMP_TimeStart = 6*24*60 + 23*60 + 55;//10080;
            //10050 = 23:30 day 6;
            //10070 = 23:50 day 6;

      //      myBot.createAgent();
        }

    }

    private static void generateEvents(int days, int multiplicator, String in, String out) {
        String evtIn = in;
        String evtTo = out;
        boolean initialized = false;

        int maxTime = days * 24 * 60;
        FileOutputStream evtLogOut = null;
        ObjectOutputStream evtStreamOut = null;
        try {
            evtLogOut = new FileOutputStream(evtTo);
            evtStreamOut = new ObjectOutputStream(evtLogOut);
        } catch (Exception e) {
        }
        for (int i = 0; i < multiplicator; i++) {
            try {
                FileInputStream evtLogIn = new FileInputStream(evtIn);
                ObjectInputStream evtStreamIn = new ObjectInputStream(evtLogIn);

                PogamutEndEvent evt = null;
                while (true) {
                    evt = null;
                    evt = (PogamutEndEvent) evtStreamIn.readObject();
                    if (evt.type == PogamutEndEventType.INIT_DECISION_TREE) {
                        if (initialized) {
                            continue;
                        } else {
                            initialized = true;
                        }
                    }
                    if (evt.time > maxTime) break;
                    evt.time += i*maxTime;
                    evtStreamOut.writeObject(evt);

                    if (evt.type == PogamutEndEventType.ATOMIC_ACTION_EXECUTED) {
                        generateObserveAction(evt, evtStreamOut);
                    }
                }
                evtStreamOut.flush();
                evtStreamIn.close();
                evtLogIn.close();
            } catch (Exception e) {
                System.err.println(e);
            }
        }
        try {
            evtStreamOut.close();
            evtLogOut.close();
        } catch (Exception e) {
            System.err.println(e);
        }
        throw new RuntimeException("events generated");
    }

    static int nextAddTime = 12*60;
    static final int intervalTime = 24*60;
    static final int maxAddTime = 19*24*60;
    private static  XStream xstream = new XStream();

    private static void generateObserveAction(PogamutEndEvent evt, ObjectOutputStream out) throws IOException {
        if (evt.time < nextAddTime || evt.time > maxAddTime) {
            return;
        }
        PogamutEndEvent evt2 = (PogamutEndEvent) xstream.fromXML(xstream.toXML(evt));

        nextAddTime += intervalTime;
        evt2.atomic = "OBSERVE";
        evt2.trace.clear();
        evt2.trace.add("AObserve");
        evt2.trace.add("IObserve");
        evt2.affordances.clear();

        final int totalRegularItems = 15;
        final int seenRegularItems = 9;
        final int totalRareItems = 25;
        final int seenRareItems = 2;
        Random randomGenerator = new Random();
        int randomInt = 0;
        int valuesReg[] = new int[totalRegularItems];
        int valuesRar[] = new int[totalRareItems];
        for (int i = 0; i < totalRegularItems; i++) {
            valuesReg[i] = i;
        }
        for (int i = 0; i < totalRareItems; i++) {
            valuesRar[i] = i;
        }
        int temp;
        for (int i = 0; i < seenRegularItems; i++) {
            PogamutEndAffordanceUsed aff = new PogamutEndAffordanceUsed("AObserve", "perceived", null);
            randomInt = randomGenerator.nextInt(totalRegularItems-i);
            aff.item = "regular" + valuesReg[randomInt];
            temp = valuesReg[totalRegularItems-i-1];
            valuesReg[totalRegularItems-i-1] = valuesReg[randomInt];
            valuesReg[randomInt] = temp;
            evt2.affordances.add(aff);
        }
        for (int i = 0; i < seenRareItems; i++) {
            PogamutEndAffordanceUsed aff = new PogamutEndAffordanceUsed("AObserve", "perceived", null);
            randomInt = randomGenerator.nextInt(totalRareItems-i);
            aff.item = "rare" + valuesRar[randomInt];
            temp = valuesRar[totalRareItems-i-1];
            valuesRar[totalRareItems-i-1] = valuesRar[randomInt];
            valuesRar[randomInt] = temp;
            evt2.affordances.add(aff);
        }

        out.writeObject(evt2);
    }
}
