/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.IncomingProjectile;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import nl.tudelft.pogamut.ut2004.agent.module.sensor.Projectiles;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.AbstractWeaponShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.util.FacingUtil;

public class ShieldGunShooting
extends AbstractWeaponShooting {
    protected static final int INCOMMING_PROJECTILE_MIN_THREAT_DISTANCE = 750;
    protected static final double SHIELD_GUN_SEC_BURST_DURATION = 1.0;
    protected static final WeaponPref DEFAULT_WEAPON_PREF = new WeaponPref(ItemType.SHIELD_GUN, false);
    protected Projectiles projectiles;
    protected Senses senses;

    public ShieldGunShooting(UT2004Bot<?, ?, ?> bot, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry, Projectiles projectiles, Senses senses) {
        super(bot, info, shoot, weaponry);
        this.projectiles = projectiles;
        this.senses = senses;
    }

    @Override
    protected void shoot() {
        if (!this.isWeaponReady()) {
            return;
        }
        this.focus.setFocus(this.target);
        if (this.weaponPref.isPrimary()) {
            this.shootPrimary();
        } else {
            this.shootSecondary();
        }
    }

    protected void shootPrimary() {
        if (this.target == null) {
            this.shoot.shoot();
            return;
        }
        this.shoot.shootPrimary(this.target);
    }

    protected void shootSecondary() {
        boolean fireDangerous;
        IncomingProjectile projectile = this.projectiles.getNearestProjectile((ILocated)this.agent, 750.0);
        if (projectile != null) {
            IncomingProjectile safeTarget = this.target == null ? projectile : this.target;
            this.shoot.shootSecondaryCharged((ILocated)safeTarget, 1.0);
            this.focus.setFocus((ILocated)safeTarget);
            return;
        }
        if (this.senses.isShot()) {
            ILocated safeTarget = this.target == null ? (ILocated)this.agent : this.target;
            this.shoot.shootSecondaryCharged(safeTarget, 1.0);
            return;
        }
        if (!this.hasTarget()) {
            return;
        }
        if (!(this.target instanceof Player)) {
            this.shoot.shootSecondaryCharged(this.target, 1.0);
            return;
        }
        Player player = (Player)this.target;
        boolean hitScanWeapon = player.getWeapon().contains("Shock") || player.getWeapon().contains("Lightning") || player.getWeapon().contains("Sniper");
        boolean bl = fireDangerous = player.getFiring() > 0 || hitScanWeapon;
        if (player.isVisible() && fireDangerous && FacingUtil.isFacing(player, (ILocated)this.agent, 25.0)) {
            this.shoot.shootSecondaryCharged(this.target, 1.0);
            return;
        }
    }

    @Override
    protected WeaponPref getDefaultWeaponPref() {
        return DEFAULT_WEAPON_PREF;
    }
}

