package nl.tudelft.pogamut.ut2004.agent.module.shooting.weapon;

import java.util.concurrent.TimeUnit;

import nl.tudelft.pogamut.ut2004.agent.module.shooting.AbstractWeaponShooting;
import nl.tudelft.pogamut.ut2004.agent.module.shooting.util.FacingUtil;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.Heatup;

/**
 * 
 * <p>
 * Module to work efficiently with the Ion Painter.
 * </p>
 * 
 * <p>
 * </p>
 * 
 * @author mpkorstanje
 * 
 */
public class IonPainterShooting extends AbstractWeaponShooting {

	protected static final WeaponPref DEFAULT_WEAPON_PREF = new WeaponPref(ItemType.ION_PAINTER, false);

	public IonPainterShooting(UT2004Bot<?, ?, ?> agent, AgentInfo info, ImprovedShooting shoot, Weaponry weaponry) {
		super(agent, info, shoot, weaponry);
	}

	protected static int ION_PAINTER_CHARGE_TIME = 3;
	
	private Heatup chargeTime = new Heatup(ION_PAINTER_CHARGE_TIME, TimeUnit.SECONDS);

	@Override
	protected void shoot() {

		// Wrong weapon, wait up.
		if (!isWeaponReady()) {
			return;
		}

		// No target, no shoot.
		if (!hasTarget()) {
			shoot.stopShooting();
			return;
		}
 
		if (chargeTime.isHot()) {
			return;
		}

		if (!(target instanceof Player)) {
			shoot.shootPrimaryCharged(target, ION_PAINTER_CHARGE_TIME);
			chargeTime.heat();
			return;
		}

		Player player = (Player) target;

		// Target not visible, hold fire.
		if (!player.isVisible() || !FacingUtil.isFacing2D(info, player, FACING_ANGLE)) {
			return;
		}
		
		shoot.shootPrimaryCharged(player, ION_PAINTER_CHARGE_TIME);
		chargeTime.heat();

	}

	@Override
	protected WeaponPref getDefaultWeaponPref() {
		return DEFAULT_WEAPON_PREF;
	}

}
