package nl.tudelft.pogamut.unreal.agent.module.shooting;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPrefs;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;

/**
 * Implementing modulus should provide a simple way to efficiently utilize the
 * weapons in unreal tournament. This includes using charging weapons and using
 * combos.
 * 
 * @author mpkorstanje
 * 
 */
public interface WeaponShooting {

	/**
	 * Shoots a given target in an effective way. The weapon preference is only
	 * used to determine which fire mode is preferred. The weapon use is
	 * determined by {@link WeaponShooting#getWeaponType()}.
	 * 
	 * Callers should make sure that the weapon used by Shoot is available and
	 * has sufficient ammo. (Generally through using {@link WeaponPrefs}).
	 * 
	 * While a target is given, shooting will try to attack this target however
	 * it may smartly refuse to shoot if the target is no longer visible. It may
	 * not refuse to stop shooting at targets that are out of range, the
	 * {@link WeaponPrefs} module should make this decision.
	 * 
	 * @param weaponPref
	 *            the preferred firing mode to use. Weapon use is determined by
	 *            module.
	 * @param target
	 *            to shoot.
	 */
	public void shoot(WeaponPref weaponPref, ILocated target);

	/**
	 * Stops the shooting. This may result in the discharge when a weapon has
	 * been charging.
	 * 
	 * TODO: Modules should handle this gracefully.
	 */
	public void stopShoot();

	/**
	 * The weapon type this module can do the shooting for.
	 * 
	 * @return the weapon type we'll shoot with.
	 */
	public ItemType getWeaponType();

	/**
	 * True when this module has been activated and is managing a weapon.
	 * 
	 * @return true when this module has been activated and is managing a
	 *         weapon.
	 */
	public boolean isActive();

	/**
	 * Should return a self updating object that indicates where the owner wants
	 * to focus.
	 * 
	 * @return a focus indicating where the owner wants to focus.
	 */
	public ILocated getFocus();


}
