/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.floydwarshall;

import cz.cuni.amis.pogamut.base.agent.IGhostAgent;
import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.tudelft.goal.ut2004.floydwarshall.FloydWarshallMap;
import nl.tudelft.goal.ut2004.floydwarshall.FloydWarshallMapCache;

public class SharedFloydWarshallMap
extends SensorModule<IGhostAgent>
implements IPathPlanner<NavPoint> {
    protected int badEdgeFlag = 0;
    protected FloydWarshallMap sharedMap = null;
    private IWorldEventListener<MapPointListObtained> mapListener = new IWorldEventListener<MapPointListObtained>(){

        public void notify(MapPointListObtained event) {
            if (SharedFloydWarshallMap.this.log.isLoggable(Level.INFO)) {
                SharedFloydWarshallMap.this.log.info("Map point list obtained.");
            }
            SharedFloydWarshallMap.this.sharedMap = FloydWarshallMapCache.getInstance().createMap(event, SharedFloydWarshallMap.this.badEdgeFlag, SharedFloydWarshallMap.this.log);
        }
    };

    public SharedFloydWarshallMap(IGhostAgent bot) {
        this(bot, null);
    }

    public SharedFloydWarshallMap(IGhostAgent bot, Logger log) {
        this(bot, FloydWarshallMap.BAD_EDGE_FLAG, log);
    }

    public SharedFloydWarshallMap(IGhostAgent bot, int badEdgeFlag, Logger log) {
        super((IObservingAgent)bot, log);
        this.badEdgeFlag = badEdgeFlag;
        this.worldView.addEventListener(MapPointListObtained.class, this.mapListener);
    }

    private List<NavPoint> clean(List<NavPoint> shared) {
        if (shared == null) {
            return null;
        }
        ArrayList<NavPoint> clean = new ArrayList<NavPoint>(shared.size());
        for (NavPoint navpoint : shared) {
            clean.add(this.clean(navpoint));
        }
        return clean;
    }

    private NavPoint clean(NavPoint shared) {
        return (NavPoint)this.worldView.get((WorldObjectId)shared.getId(), NavPoint.class);
    }

    public IPathFuture<NavPoint> computePath(NavPoint from, NavPoint to) {
        return new PrecomputedPathFuture((Object)from, (Object)to, this.getPath(from, to));
    }

    public boolean reachable(NavPoint from, NavPoint to) {
        return this.sharedMap.reachable(from, to);
    }

    public float getDistance(NavPoint from, NavPoint to) {
        return this.sharedMap.getDistance(from, to);
    }

    public List<NavPoint> getPath(NavPoint from, NavPoint to) {
        return this.clean(this.sharedMap.getPath(from, to));
    }

    public boolean checkLink(NavPointNeighbourLink edge) {
        return this.sharedMap.checkLink(edge);
    }

    protected void cleanUp() {
        super.cleanUp();
        this.sharedMap = null;
    }
}

