package nl.tudelft.goal.ut2004.agent;

import java.util.ArrayList;
import java.util.List;

import nl.tudelft.goal.unreal.messages.BotParameters;
import nl.tudelft.goal.unreal.messages.Parameters;
import nl.tudelft.goal.unreal.translators.LocationTranslator;
import nl.tudelft.goal.unreal.translators.RotationTranslator;
import nl.tudelft.goal.unreal.translators.TeamTranslator;
import nl.tudelft.goal.unreal.translators.UnrealIdTranslator;
import nl.tudelft.goal.unreal.translators.VelocityTranslator;
import nl.tudelft.goal.ut2004.messages.UnrealIdOrLocation;
import nl.tudelft.goal.ut2004.translators.CategoryTranslator;
import nl.tudelft.goal.ut2004.translators.ComboTranslator;
import nl.tudelft.goal.ut2004.translators.FireModeTranslator;
import nl.tudelft.goal.ut2004.translators.FlagStateTranslator;
import nl.tudelft.goal.ut2004.translators.GameTypeTranslator;
import nl.tudelft.goal.ut2004.translators.ItemTypeTranslator;
import nl.tudelft.goal.ut2004.translators.NavigationStateTranslator;
import nl.tudelft.goal.ut2004.translators.NoneTranslator;
import nl.tudelft.goal.ut2004.translators.PerceptTranslator;
import nl.tudelft.goal.ut2004.translators.SelectorListTranslator;
import nl.tudelft.goal.ut2004.translators.SelectorTranslator;
import nl.tudelft.goal.ut2004.translators.UnrealIdOrLocationTranslator;
import nl.tudelft.goal.ut2004.translators.WeaponPrefListTranslator;
import nl.tudelft.goal.ut2004.translators.WeaponPrefTranslator;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import eis.eis2java.handlers.ActionHandler;
import eis.eis2java.handlers.AllPerceptPerceptHandler;
import eis.eis2java.handlers.DefaultActionHandler;
import eis.eis2java.handlers.PerceptHandler;
import eis.eis2java.translation.Translator;
import eis.eis2java.util.AllPerceptsProvider;
import eis.exceptions.EntityException;
import eis.exceptions.PerceiveException;

/**
 * Test class to make the agent do custom stuff.
 * 
 * @author mpkorstanje
 * 
 */
public class RunAgent {

	public static void main(String[] args) throws EntityException, InterruptedException, PerceiveException {

		Translator translator = Translator.getInstance();

		/*
		 * Translators provided by the BaseUnrealEnvironment.
		 * 
		 * Please list these in lexical order.
		 */

		LocationTranslator locationTranslator = new LocationTranslator();
		translator.registerJava2ParameterTranslator(locationTranslator);
		translator.registerParameter2JavaTranslator(locationTranslator);

		/*
		 * To translate from Parameter2Java we are given an UnrealId. However we
		 * can not access the agents memory during translation. To work around
		 * this we store everything we have send to any agent. Hence the same
		 * object has to be used for both directions.
		 */

		RotationTranslator rotationTranslator = new RotationTranslator();
		translator.registerJava2ParameterTranslator(rotationTranslator);
		translator.registerParameter2JavaTranslator(rotationTranslator);

		TeamTranslator teamTranslator = new TeamTranslator();
		translator.registerJava2ParameterTranslator(teamTranslator);
		translator.registerParameter2JavaTranslator(teamTranslator);

		UnrealIdTranslator unrealIdTranslator = new UnrealIdTranslator();
		translator.registerJava2ParameterTranslator(unrealIdTranslator);
		translator.registerParameter2JavaTranslator(unrealIdTranslator);

		VelocityTranslator velocityTranslator = new VelocityTranslator();
		translator.registerJava2ParameterTranslator(velocityTranslator);
		translator.registerParameter2JavaTranslator(velocityTranslator);
		/*
		 * Translators provided by the UT2004 environment.
		 * 
		 * Please list these in lexical order.
		 */

		CategoryTranslator itemTypeTranslator = new CategoryTranslator();
		translator.registerJava2ParameterTranslator(itemTypeTranslator);

		ComboTranslator comboTranslator = new ComboTranslator();
		translator.registerParameter2JavaTranslator(comboTranslator);

		FireModeTranslator fireModeTranslator = new FireModeTranslator();
		translator.registerJava2ParameterTranslator(fireModeTranslator);
		translator.registerParameter2JavaTranslator(fireModeTranslator);

		FlagStateTranslator flagStateTranslator = new FlagStateTranslator();
		translator.registerJava2ParameterTranslator(flagStateTranslator);

		GameTypeTranslator gameTypeTranslator = new GameTypeTranslator();
		translator.registerJava2ParameterTranslator(gameTypeTranslator);

		ItemTypeTranslator categoryTranslator = new ItemTypeTranslator();
		translator.registerJava2ParameterTranslator(categoryTranslator);
		translator.registerParameter2JavaTranslator(categoryTranslator);

		NavigationStateTranslator navigationStateTranslator = new NavigationStateTranslator();
		translator.registerJava2ParameterTranslator(navigationStateTranslator);

		NoneTranslator noneTranslator = new NoneTranslator();
		translator.registerJava2ParameterTranslator(noneTranslator);

		PerceptTranslator perceptTranslator = new PerceptTranslator();
		translator.registerJava2ParameterTranslator(perceptTranslator);

		SelectorListTranslator selectorListTranslator = new SelectorListTranslator();
		translator.registerParameter2JavaTranslator(selectorListTranslator);

		SelectorTranslator selectorTranslator = new SelectorTranslator();
		translator.registerParameter2JavaTranslator(selectorTranslator);

		UnrealIdOrLocationTranslator unrealIdOrLocationTranslator = new UnrealIdOrLocationTranslator();
		translator.registerParameter2JavaTranslator(unrealIdOrLocationTranslator);

		WeaponPrefListTranslator weaponPrefListTranslator = new WeaponPrefListTranslator();
		translator.registerParameter2JavaTranslator(weaponPrefListTranslator);

		WeaponPrefTranslator weaponPrefTranslator = new WeaponPrefTranslator();
		translator.registerParameter2JavaTranslator(weaponPrefTranslator);

		@SuppressWarnings("rawtypes")
		UT2004BotRunner<UT2004Bot, UT2004BotParameters> runner = new UT2004BotRunner<UT2004Bot, UT2004BotParameters>(
				UT2004BotBehavior.class, Parameters.DEFAULT_NAME, Parameters.LOCAL_HOST, Parameters.BOT_SERVER_PORT);
		runner.setConsoleLogging(true);

		AgentLogger log = new AgentLogger(new AgentId("Test"));
		BotParameters parameters = new BotParameters(log);
		parameters.setAgentId("SimpleRed 1");
		// parameters.setSkin(Skin.BotA);
		// parameters.setTeam(Team.RED);
		parameters.assignDefaults(BotParameters.getDefaults(log));
		BotParameters parameters1 = new BotParameters(log);
		parameters1.setAgentId("SimpleRed 2");
		// parameters.setSkin(Skin.BotA);
		// parameters.setTeam(Team.RED);
		parameters.assignDefaults(BotParameters.getDefaults(log));
		BotParameters parameters2 = new BotParameters(log);
		parameters2.setAgentId("SimpleRed 3");
		// parameters.setSkin(Skin.BotA);
		// parameters.setTeam(Team.RED);
		parameters2.assignDefaults(BotParameters.getDefaults(log));

		List<UT2004Bot> agents = runner.startAgents(parameters, parameters1, parameters2);
		List<PerceptHandler> handlers = new ArrayList<PerceptHandler>(agents.size());
		List<ActionHandler> actionHandlers = new ArrayList<ActionHandler>(agents.size());

		for (UT2004Bot agent : agents) {
			PerceptHandler handler = new AllPerceptPerceptHandler((AllPerceptsProvider) agent.getController());
			handlers.add(handler);
		}

		for (UT2004Bot agent : agents) {
			ActionHandler handler = new DefaultActionHandler(agent.getController());
			actionHandlers.add(handler);
		}

		while (true) {

			Thread.sleep(500);

			for (PerceptHandler handler : handlers) {
				System.out.println(handler.getAllPercepts());
			}

			UT2004BotBehavior behavior = ((UT2004BotBehavior) agents.get(0).getController());
			Player p = behavior.getPlayers().getNearestVisiblePlayer();
			if (p != null)
				behavior.navigate(new UnrealIdOrLocation(p.getId()));
		}

	}

}
