/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.astar;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.utils.astar.AStarMap;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UT2004AStarMap
extends SensorModule<IObservingAgent>
implements AStarMap<NavPoint> {
    private LazyMap<NavPoint, List<NavPoint>> neighbours = new LazyMap<NavPoint, List<NavPoint>>(){

        @Override
        protected List<NavPoint> create(NavPoint key) {
            ArrayList<NavPoint> list = new ArrayList<NavPoint>(key.getOutgoingEdges().size());
            for (NavPointNeighbourLink link : key.getOutgoingEdges().values()) {
                list.add(link.getToNavPoint());
            }
            return list;
        }
    };

    public UT2004AStarMap(IObservingAgent agent) {
        super(agent);
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this.neighbours.clear();
    }

    @Override
    public int getEdgeCost(NavPoint nodeFrom, NavPoint nodeTo) {
        return (int)nodeTo.getLocation().getDistance(nodeFrom.getLocation());
    }

    @Override
    public Collection<NavPoint> getNodeNeighbours(NavPoint node) {
        return this.neighbours.get(node);
    }

    @Override
    public int getNodeCost(NavPoint node) {
        return 0;
    }
}

