/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.environment;

import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotController;
import cz.cuni.amis.utils.flag.FlagListener;
import eis.eis2java.handlers.ActionHandler;
import eis.eis2java.handlers.AllPerceptPerceptHandler;
import eis.eis2java.handlers.DefaultActionHandler;
import eis.eis2java.handlers.PerceptHandler;
import eis.eis2java.translation.Java2Parameter;
import eis.eis2java.translation.Parameter2Java;
import eis.eis2java.translation.Translator;
import eis.eis2java.util.AllPerceptsProvider;
import eis.exceptions.EntityException;
import eis.exceptions.ManagementException;
import eis.iilang.Identifier;
import eis.iilang.Parameter;
import eis.iilang.ParameterList;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import nl.tudelft.goal.unreal.environment.AbstractUnrealEnvironment;
import nl.tudelft.goal.unreal.messages.BotParameters;
import nl.tudelft.goal.unreal.translators.LocationTranslator;
import nl.tudelft.goal.unreal.translators.RotationTranslator;
import nl.tudelft.goal.unreal.translators.TeamTranslator;
import nl.tudelft.goal.unreal.translators.UnrealIdTranslator;
import nl.tudelft.goal.unreal.translators.VelocityTranslator;
import nl.tudelft.goal.ut2004.agent.UT2004BotBehavior;
import nl.tudelft.goal.ut2004.translators.CategoryTranslator;
import nl.tudelft.goal.ut2004.translators.ComboTranslator;
import nl.tudelft.goal.ut2004.translators.FireModeTranslator;
import nl.tudelft.goal.ut2004.translators.FlagStateTranslator;
import nl.tudelft.goal.ut2004.translators.GameTypeTranslator;
import nl.tudelft.goal.ut2004.translators.ItemTypeTranslator;
import nl.tudelft.goal.ut2004.translators.NavigationStateTranslator;
import nl.tudelft.goal.ut2004.translators.NoneTranslator;
import nl.tudelft.goal.ut2004.translators.PerceptTranslator;
import nl.tudelft.goal.ut2004.translators.SelectorListTranslator;
import nl.tudelft.goal.ut2004.translators.SelectorTranslator;
import nl.tudelft.goal.ut2004.translators.UnrealIdOrLocationTranslator;
import nl.tudelft.goal.ut2004.translators.WeaponPrefListTranslator;
import nl.tudelft.goal.ut2004.translators.WeaponPrefTranslator;
import nl.tudelft.goal.ut2004.visualizer.connection.AddBotCommand;
import nl.tudelft.goal.ut2004.visualizer.connection.EnvironmentService;
import nl.tudelft.goal.ut2004.visualizer.connection.EnvironmentServiceListener;
import nl.tudelft.goal.ut2004.visualizer.connection.EnvironmentServiceMediator;
import nl.tudelft.goal.ut2004.visualizer.connection.client.RemoteVisualizer;
import nl.tudelft.goal.ut2004.visualizer.connection.client.VisualizerServiceDefinition;
import nl.tudelft.pogamut.base.server.ReconnectingServerDefinition;
import nl.tudelft.pogamut.base.server.ServerDefinition;

public class UT2004Environment
extends AbstractUnrealEnvironment {
    private static final long serialVersionUID = 8240549393243585632L;
    private ReconnectingServerDefinition<RemoteVisualizer> visualizerConnection;

    protected void registerTranslators() {
        Translator translator = Translator.getInstance();
        LocationTranslator locationTranslator = new LocationTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)locationTranslator);
        translator.registerParameter2JavaTranslator((Parameter2Java)locationTranslator);
        RotationTranslator rotationTranslator = new RotationTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)rotationTranslator);
        translator.registerParameter2JavaTranslator((Parameter2Java)rotationTranslator);
        TeamTranslator teamTranslator = new TeamTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)teamTranslator);
        translator.registerParameter2JavaTranslator((Parameter2Java)teamTranslator);
        UnrealIdTranslator unrealIdTranslator = new UnrealIdTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)unrealIdTranslator);
        translator.registerParameter2JavaTranslator((Parameter2Java)unrealIdTranslator);
        VelocityTranslator velocityTranslator = new VelocityTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)velocityTranslator);
        translator.registerParameter2JavaTranslator((Parameter2Java)velocityTranslator);
        CategoryTranslator itemTypeTranslator = new CategoryTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)itemTypeTranslator);
        ComboTranslator comboTranslator = new ComboTranslator();
        translator.registerParameter2JavaTranslator((Parameter2Java)comboTranslator);
        FireModeTranslator fireModeTranslator = new FireModeTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)fireModeTranslator);
        translator.registerParameter2JavaTranslator((Parameter2Java)fireModeTranslator);
        FlagStateTranslator flagStateTranslator = new FlagStateTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)flagStateTranslator);
        GameTypeTranslator gameTypeTranslator = new GameTypeTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)gameTypeTranslator);
        ItemTypeTranslator categoryTranslator = new ItemTypeTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)categoryTranslator);
        translator.registerParameter2JavaTranslator((Parameter2Java)categoryTranslator);
        NavigationStateTranslator navigationStateTranslator = new NavigationStateTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)navigationStateTranslator);
        NoneTranslator noneTranslator = new NoneTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)noneTranslator);
        PerceptTranslator perceptTranslator = new PerceptTranslator();
        translator.registerJava2ParameterTranslator((Java2Parameter)perceptTranslator);
        SelectorListTranslator selectorListTranslator = new SelectorListTranslator();
        translator.registerParameter2JavaTranslator((Parameter2Java)selectorListTranslator);
        SelectorTranslator selectorTranslator = new SelectorTranslator();
        translator.registerParameter2JavaTranslator((Parameter2Java)selectorTranslator);
        UnrealIdOrLocationTranslator unrealIdOrLocationTranslator = new UnrealIdOrLocationTranslator();
        translator.registerParameter2JavaTranslator((Parameter2Java)unrealIdOrLocationTranslator);
        WeaponPrefListTranslator weaponPrefListTranslator = new WeaponPrefListTranslator();
        translator.registerParameter2JavaTranslator((Parameter2Java)weaponPrefListTranslator);
        WeaponPrefTranslator weaponPrefTranslator = new WeaponPrefTranslator();
        translator.registerParameter2JavaTranslator((Parameter2Java)weaponPrefTranslator);
    }

    public static void main(String[] args) throws ManagementException {
        HashMap<String, ParameterList> map = new HashMap<String, ParameterList>();
        map.put("botNames", new ParameterList(new Parameter[]{new Identifier("Test")}));
        new UT2004Environment().init(map);
    }

    protected Class<UT2004BotBehavior> getControlerClass() {
        return UT2004BotBehavior.class;
    }

    protected PerceptHandler createPerceptHandler(UT2004BotController controller) throws EntityException {
        if (!(controller instanceof AllPerceptsProvider)) {
            throw new EntityException("Expected a class that implements " + AllPerceptsProvider.class.getSimpleName());
        }
        return new AllPerceptPerceptHandler((AllPerceptsProvider)controller);
    }

    protected ActionHandler createActionHandler(UT2004BotController controller) throws EntityException {
        return new DefaultActionHandler((Object)controller);
    }

    protected synchronized void initializeEnvironment(Map<String, Parameter> parameters) throws ManagementException {
        super.initializeEnvironment(parameters);
        try {
            this.visualizerConnection = new ReconnectingServerDefinition((ServerDefinition)new VisualizerServiceDefinition());
            this.visualizerConnection.getServerFlag().addListener((FlagListener)new VisualizerServiceListener());
        }
        catch (RemoteException e) {
            this.log.severe("Could not start connection to Visualizer: " + e);
        }
    }

    protected synchronized void connectEnvironment() throws ManagementException {
        super.connectEnvironment();
        URI visualizerUri = this.environmentParameters.getVisualizerServer();
        if (visualizerUri != null) {
            this.log.info("Connecting to visualizer server at " + visualizerUri + " .");
            this.visualizerConnection.setUri(visualizerUri);
        } else {
            this.log.info("No address for the visualizer server was provided. The environment will not try to connect to the visualizer.");
        }
    }

    protected synchronized void killEnvironment() {
        super.killEnvironment();
        this.visualizerConnection.stopServer();
    }

    private class VisualizerServiceListener
    implements EnvironmentServiceListener,
    FlagListener<RemoteVisualizer> {
        private final EnvironmentServiceMediator mediator;

        public VisualizerServiceListener() throws RemoteException {
            this.mediator = new EnvironmentServiceMediator(UT2004Environment.this.getComponentId());
            this.mediator.setListener((EnvironmentServiceListener)this);
        }

        public void flagChanged(RemoteVisualizer visualizer) {
            if (visualizer != null) {
                visualizer.setEnvironment((EnvironmentService)this.mediator);
            }
        }

        public void addBot(AddBotCommand command) throws ManagementException {
            BotParameters parameters = new BotParameters(UT2004Environment.this.environmentLogger);
            if (command.getBotName() != null) {
                parameters.setAgentId(command.getBotName());
            }
            if (command.getLogLevel() != null) {
                parameters.setLogLevel(command.getLogLevel());
            }
            if (command.getShouldLeadTarget() != null) {
                parameters.setShouldLeadTarget(command.getShouldLeadTarget().booleanValue());
            }
            if (command.getSkill() != null) {
                parameters.setSkill(command.getSkill().intValue());
            }
            if (command.getSkin() != null) {
                parameters.setSkin(command.getSkin());
            }
            if (command.getTeam() != null) {
                parameters.setTeam(command.getTeam());
            }
            if (command.getRotation() != null) {
                parameters.setInitialRotation(command.getRotation());
            }
            if (command.getLocation() != null) {
                parameters.setInitialLocation(command.getLocation());
            }
            parameters.assignDefaults((IAgentParameters)UT2004Environment.this.botParameters);
            UT2004Environment.this.startAgents(new BotParameters[]{parameters});
        }
    }
}

