/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.floydwarshall;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import nl.tudelft.goal.ut2004.floydwarshall.FloydWarshallMap;

public final class FloydWarshallMapCache {
    private static FloydWarshallMapCache instance;
    private final Map<MapKey, WeakReference<FloydWarshallMap>> cache = new HashMap<MapKey, WeakReference<FloydWarshallMap>>();

    private FloydWarshallMapCache() {
    }

    public synchronized FloydWarshallMap createMap(MapPointListObtained event, int badEdgeFlag, Logger log) {
        MapKey key = new MapKey(event.getNavPoints(), badEdgeFlag);
        FloydWarshallMap sharedMap = null;
        if (this.cache.containsKey(key)) {
            sharedMap = (FloydWarshallMap)this.cache.get(key).get();
        }
        if (sharedMap != null) {
            log.info("Map exists for " + key);
        } else {
            log.info("Creating new map for " + key);
            sharedMap = new FloydWarshallMap(badEdgeFlag, log);
            sharedMap.performFloydWarshall(event);
            this.cache.put(key, new WeakReference<FloydWarshallMap>(sharedMap));
        }
        return sharedMap;
    }

    public static synchronized FloydWarshallMapCache getInstance() {
        if (instance == null) {
            instance = new FloydWarshallMapCache();
        }
        return instance;
    }

    private static final class MapKey {
        private final String id;
        private final int badEdgeFlag;

        public String toString() {
            return "MapKey [id=" + this.id + ", badEdgeFlag=" + this.badEdgeFlag + "]";
        }

        public MapKey(Map<UnrealId, NavPoint> map, int badEdgeFlag) {
            this.id = this.getSmallest(map.keySet());
            this.badEdgeFlag = badEdgeFlag;
        }

        private String getSmallest(Set<UnrealId> set) {
            if (set.isEmpty()) {
                return null;
            }
            String smallestString = set.iterator().next().getStringId();
            for (UnrealId candidate : set) {
                String candidateString = candidate.getStringId();
                if (candidateString.compareTo(smallestString) >= 0) continue;
                smallestString = candidateString;
            }
            return smallestString;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.badEdgeFlag;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MapKey)) {
                return false;
            }
            MapKey other = (MapKey)obj;
            if (this.badEdgeFlag != other.badEdgeFlag) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }
}

