/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.map;

import java.awt.Color;

public class TeamShade {
    private Color personalBase;
    private Color personalRed;
    private Color personalBlue;
    private Color redTeam;
    private Color blueTeam;
    private static final double TEAM_COLOR_STRENGHT = 0.25;

    public TeamShade() {
        this(TeamShade.randomColor());
    }

    public TeamShade(Color personalColor) {
        this(personalColor, Color.RED, Color.BLUE);
    }

    public TeamShade(Color redteam, Color blueTeam) {
        this(TeamShade.randomColor(), redteam, blueTeam);
    }

    public TeamShade(Color personalColor, Color redTeam, Color blueTeam) {
        this.personalBase = personalColor;
        this.redTeam = redTeam;
        this.blueTeam = blueTeam;
        this.personalRed = this.mix(redTeam, this.personalBase, 0.25);
        this.personalBlue = this.mix(blueTeam, this.personalBase, 0.25);
    }

    public Color getColor(int team) {
        switch (team) {
            case 0: {
                return this.personalRed;
            }
            case 1: {
                return this.personalBlue;
            }
        }
        return this.personalBase;
    }

    private Color mix(Color a, Color b, double portion) {
        double thisPortion = 1.0 - portion;
        return new Color((int)(thisPortion * (double)a.getRed()) + (int)(portion * (double)b.getRed()), (int)(thisPortion * (double)a.getGreen()) + (int)(portion * (double)b.getGreen()), (int)(thisPortion * (double)a.getBlue()) + (int)(portion * (double)b.getBlue()), (int)(thisPortion * (double)a.getAlpha()) + (int)(portion * (double)b.getAlpha()));
    }

    private static Color randomColor() {
        return new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    }

    public Color getRedTeam() {
        return this.redTeam;
    }

    public void setRedTeam(Color redTeam) {
        this.redTeam = redTeam;
        this.personalRed = this.mix(redTeam, this.personalBase, 0.25);
    }

    public Color getBlueTeam() {
        return this.blueTeam;
    }

    public void setBlueTeam(Color blueTeam) {
        this.blueTeam = blueTeam;
        this.personalBlue = this.mix(blueTeam, this.personalBase, 0.25);
    }
}

