/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.ut2004.visualizer.map;

import cz.cuni.amis.pogamut.unreal.server.IUnrealServer;
import cz.cuni.amis.utils.flag.FlagListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import nl.tudelft.goal.ut2004.visualizer.map.PureMapGLPanel;
import nl.tudelft.goal.ut2004.visualizer.services.ISelectionHandler;
import nl.tudelft.pogamut.base.server.ServerDefinition;

public class PureMapTopPanel
extends JPanel {
    private static final long serialVersionUID = -448000130214012550L;
    protected final ServerDefinition<IUnrealServer> serverDefinition;
    protected PureMapGLPanel mapPanel;
    private ISelectionHandler selectionHandler;

    public PureMapTopPanel(ServerDefinition<IUnrealServer> serverDefinition) {
        this.serverDefinition = serverDefinition;
        this.setLayout(new BorderLayout());
        this.handleServerChanged();
        this.handleVisibility();
        this.handleServerName();
        this.handleServer();
    }

    private void handleVisibility() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (PureMapTopPanel.this.mapPanel != null) {
                    PureMapTopPanel.this.mapPanel.startDisplayLoop();
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                if (PureMapTopPanel.this.mapPanel != null) {
                    PureMapTopPanel.this.mapPanel.stopDisplayLoop();
                }
            }
        });
    }

    private void handleServerName() {
        this.setPanelName();
        this.serverDefinition.getServerNameFlag().addListener((FlagListener)new FlagListener<String>(){

            public void flagChanged(String changedValue) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PureMapTopPanel.this.setPanelName();
                    }
                });
            }
        });
    }

    protected void setPanelName() {
        String map = "no map";
        if (this.serverDefinition.getServerFlag().getFlag() != null) {
            map = ((IUnrealServer)this.serverDefinition.getServerFlag().getFlag()).getMapName();
        }
        this.setName(this.serverDefinition.getServerName() + " [" + map + "]");
    }

    private void handleServer() {
        this.serverDefinition.getServerFlag().addListener((FlagListener)new FlagListener<IUnrealServer>(){

            public void flagChanged(IUnrealServer server) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PureMapTopPanel.this.handleServerChanged();
                    }
                });
            }
        });
    }

    private void handleServerChanged() {
        this.removeAll();
        this.setPanelName();
        if (this.serverDefinition.getServerFlag().getFlag() != null) {
            this.setUpMapPanel();
        } else {
            this.add((Component)new JLabel("Not connected."), "First");
        }
        this.revalidate();
        this.repaint();
    }

    protected void setUpMapPanel() {
        if (this.mapPanel != null) {
            this.remove((Component)((Object)this.mapPanel));
            this.mapPanel.destroy();
        }
        IUnrealServer server = (IUnrealServer)this.serverDefinition.getServerFlag().getFlag();
        this.mapPanel = new PureMapGLPanel(server.getMap(), server);
        this.mapPanel.setSelectionHandler(this.selectionHandler);
        if (this.isVisible()) {
            this.mapPanel.startDisplayLoop();
        }
        this.add((Component)((Object)this.mapPanel));
    }

    public void setSelectionHandler(ISelectionHandler selectionHandler) {
        this.selectionHandler = selectionHandler;
        if (this.mapPanel != null) {
            this.mapPanel.setSelectionHandler(selectionHandler);
        }
    }
}

