/*
 * Decompiled with CFR 0.152.
 */
package SteeringStuff;

import SteeringStuff.IRaysFlagChanged;
import SteeringStuff.SteeringRay;
import SteeringStuff.SteeringType;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.Future;

public class RaycastingManager {
    private UT2004Bot botself;
    public Raycasting raycasting;
    private static boolean fastTrace = false;
    private static boolean floorCorrection = false;
    private static boolean traceActor = false;
    private HashMap<SteeringType, LinkedList<SteeringRay>> raysMap = new HashMap();
    private HashMap<SteeringType, IRaysFlagChanged> rayFlagChangedListeners = new HashMap();
    private HashMap<SteeringType, HashMap<String, Future<AutoTraceRay>>> rayFutures = new HashMap();

    public RaycastingManager(UT2004Bot botself, Raycasting raycasting) {
        this.botself = botself;
        this.raycasting = raycasting;
    }

    public void addRayFlagChangedListener(SteeringType type, IRaysFlagChanged listener) {
        this.rayFlagChangedListeners.put(type, listener);
    }

    public void notifyRayFlagChangedListeners() {
        for (IRaysFlagChanged listener : this.rayFlagChangedListeners.values()) {
            listener.flagRaysChanged();
        }
    }

    public void addRays(SteeringType type, LinkedList<SteeringRay> rayList, IRaysFlagChanged listener) {
        this.raysMap.put(type, rayList);
        this.addRayFlagChangedListener(type, listener);
        this.prepareRays();
    }

    public void removeRays(SteeringType type) {
        this.raysMap.remove(type);
        this.rayFlagChangedListeners.remove(type);
        this.prepareRays();
    }

    public HashMap<String, Future<AutoTraceRay>> getMyFutureRays(SteeringType type) {
        return this.rayFutures.get(type);
    }

    public boolean raysAreReady() {
        return this.raycasting.getAllRaysInitialized().getFlag();
    }

    private void prepareRays() {
        this.raycasting.clear();
        this.rayFutures.clear();
        for (SteeringType type : this.raysMap.keySet()) {
            LinkedList<SteeringRay> rayList = this.raysMap.get(type);
            HashMap<String, Future<AutoTraceRay>> fr = new HashMap<String, Future<AutoTraceRay>>();
            for (SteeringRay ray : rayList) {
                Future<AutoTraceRay> future = this.raycasting.createRay(ray.id, ray.direction, ray.length, fastTrace, floorCorrection, traceActor);
                fr.put(ray.id, future);
            }
            this.rayFutures.put(type, fr);
        }
        this.raycasting.endRayInitSequence();
        this.notifyRayFlagChangedListeners();
    }
}

