/**
 * BaseUnrealEnvironment, an implementation of the environment interface standard that 
 * facilitates the connection between GOAL and the UT2004 engine. 
 * 
 * Copyright (C) 2012 BaseUnrealEnvironment authors.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package nl.tudelft.goal.unreal.translators;


import nl.tudelft.goal.unreal.messages.StringList;
import eis.eis2java.exception.TranslationException;
import eis.eis2java.translation.Parameter2Java;
import eis.eis2java.translation.Translator;
import eis.iilang.Parameter;
import eis.iilang.ParameterList;

public class StringListTranslator implements Parameter2Java<StringList> {

	@Override
	public StringList translate(Parameter parameter) throws TranslationException {
		if (!(parameter instanceof ParameterList)) {
			String message = String.format("%s is not a parameter list.", parameter);
			throw new TranslationException(message);
		}

		ParameterList parameterList = (ParameterList) parameter;
		// TODO: Need size of parameter list.
		StringList list = new StringList();

		for (Parameter p : parameterList) {
			String string = Translator.getInstance().translate2Java(p, String.class);
			list.add(string);
		}

		return list;
	}

	@Override
	public Class<StringList> translatesTo() {
		return StringList.class;
	}

}