/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes.planners;

import cz.dd4j.agents.heroes.pddl.PDDLAction;
import cz.dd4j.agents.heroes.planners.AbstractPlannerExecutor;
import cz.dd4j.utils.config.AutoConfig;
import cz.dd4j.utils.config.Configurable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.io.FileUtils;

@AutoConfig
public class NPlanNativeExecutor
extends AbstractPlannerExecutor {
    @Configurable
    protected File nplanDir = new File("./nplan/");
    protected File agentWorkingDir;
    protected File nplanWorkingDir;
    protected File nplanWorkingFile;

    @Override
    public String getPddlNewLine() {
        return "\n";
    }

    @Override
    public List<PDDLAction> execPlanner(File domainFile, File problemFile) throws IOException {
        File resultFile = new File(this.nplanWorkingDir, "plan.SOL");
        FileUtils.copyFile((File)domainFile, (File)new File(this.nplanWorkingDir, "domain.pddl"));
        FileUtils.copyFile((File)problemFile, (File)new File(this.nplanWorkingDir, "problem.pddl"));
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("domain", "domain.pddl");
        config.put("problem", "problem.pddl");
        config.put("result", resultFile.getCanonicalPath());
        CommandLine commandLine = new CommandLine(new File(this.nplanDir, "nplan").getCanonicalPath());
        commandLine.addArgument("${domain}");
        commandLine.addArgument("${problem}");
        commandLine.addArgument("-o");
        commandLine.addArgument("${result}");
        commandLine.addArgument("-Q");
        commandLine.setSubstitutionMap(config);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWorkingDirectory(this.nplanWorkingDir);
        executor.setExitValue(0);
        try {
            executor.execute(commandLine);
        }
        catch (ExecuteException e) {
            if (e.getExitValue() == 139) {
                String path = this.nplanWorkingDir.getCanonicalPath();
                File crashDir = new File("nplanSegfault/" + path.substring(path.length() - 40, path.length()));
                FileUtils.copyDirectory((File)this.nplanWorkingDir, (File)crashDir);
                return null;
            }
            String path = this.nplanWorkingDir.getCanonicalPath();
            File crashDir = new File("nplanCrashes/" + path.substring(path.length() - 40, path.length()));
            FileUtils.copyDirectory((File)this.nplanWorkingDir, (File)crashDir);
            System.err.print(crashDir.getCanonicalPath());
            e.printStackTrace();
            return null;
        }
        if (!resultFile.exists()) {
            return null;
        }
        String resultLines = FileUtils.readFileToString((File)resultFile);
        resultFile.delete();
        return this.parseLines(resultLines);
    }

    @Override
    public void prepareEnvironment(File agentWorkingDir) {
        this.agentWorkingDir = agentWorkingDir;
        this.nplanWorkingDir = new File(this.agentWorkingDir, "nplan");
        this.nplanWorkingDir.mkdirs();
        this.nplanWorkingDir.deleteOnExit();
        this.nplanWorkingFile = new File(this.nplanWorkingDir, "nplan");
    }
}

