/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.agents.heroes.pddl;

import cz.cuni.amis.utils.eh4j.shortcut.EH;
import cz.dd4j.agents.HeroAgentBase;
import cz.dd4j.agents.commands.Command;
import cz.dd4j.agents.heroes.pddl.InputFiles;
import cz.dd4j.agents.heroes.pddl.PDDLAction;
import cz.dd4j.agents.heroes.planners.AbstractPlannerExecutor;
import cz.dd4j.agents.heroes.planners.NPlanCygwinExecutor;
import cz.dd4j.agents.heroes.planners.PDDLInputGenerator;
import cz.dd4j.domain.EElement;
import cz.dd4j.domain.EFeature;
import cz.dd4j.domain.EItem;
import cz.dd4j.simulation.actions.EAction;
import cz.dd4j.simulation.data.dungeon.Dungeon;
import cz.dd4j.simulation.data.dungeon.Element;
import cz.dd4j.simulation.data.dungeon.elements.entities.Entity;
import cz.dd4j.simulation.data.dungeon.elements.entities.Feature;
import cz.dd4j.simulation.data.dungeon.elements.entities.Monster;
import cz.dd4j.simulation.data.dungeon.elements.places.Room;
import cz.dd4j.utils.Const;
import cz.dd4j.utils.Id;
import cz.dd4j.utils.astar.AStar;
import cz.dd4j.utils.astar.IAStarHeuristic;
import cz.dd4j.utils.astar.IAStarView;
import cz.dd4j.utils.astar.Path;
import cz.dd4j.utils.astar.graph.INode;
import cz.dd4j.utils.config.AutoConfig;
import cz.dd4j.utils.config.Configurable;
import cz.dd4j.utils.csv.CSV;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

@AutoConfig
public class PDDLAgentBase
extends HeroAgentBase {
    @Configurable
    protected File domainFile = new File("./DarkDungeon.pddl");
    @Configurable
    protected String domainName = "DarkDungeon";
    @Configurable
    protected File agentWorkingDirBase = new File("./temp");
    @Configurable
    protected AbstractPlannerExecutor executor = new NPlanCygwinExecutor();
    @Configurable
    protected String executorClass = "cz.dd4j.agents.heroes.planners.NPlanNativeExecutor";
    protected UUID uuid;
    protected File agentWorkingDir;
    protected File problemFile;
    protected boolean workingDirExisted = true;
    protected Dungeon dungeon;
    protected boolean firstObserve = true;
    protected Map<Id, Monster> monsters = new HashMap<Id, Monster>();
    protected Map<Id, Feature> features = new HashMap<Id, Feature>();
    protected List<Room> roomsWithSword = new ArrayList<Room>();
    protected List<Room> goalRooms = new ArrayList<Room>();
    protected StringBuffer pddlStaticPartCache = new StringBuffer();
    protected String pddlNewLine = Const.NEW_LINE;
    protected PDDLInputGenerator inputGenerator;
    protected int plannerCalls = 0;
    protected int failedPlans = 0;
    protected int customPlannerCalls = 0;

    public void prepareAgent() {
        super.prepareAgent();
        this.uuid = UUID.randomUUID();
        this.agentWorkingDir = new File(this.agentWorkingDirBase, this.uuid.toString());
        if (!this.agentWorkingDir.exists()) {
            this.workingDirExisted = false;
            this.agentWorkingDir.mkdirs();
        }
        try {
            this.executor = (AbstractPlannerExecutor)Class.forName(this.executorClass).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.inputGenerator = new PDDLInputGenerator(this.agentWorkingDir);
        this.executor.prepareEnvironment(this.agentWorkingDir);
        this.problemFile = this.executor.getProblemFile();
        this.inputGenerator.setPddlNewLine(this.executor.getPddlNewLine());
        this.reset();
    }

    public void simulationEnded() {
        super.simulationEnded();
        FileUtils.deleteQuietly((File)this.agentWorkingDir);
        this.reset();
    }

    protected void reset() {
        this.monsters.clear();
        this.features.clear();
        this.roomsWithSword.clear();
        this.goalRooms.clear();
        this.firstObserve = true;
        this.pddlStaticPartCache.setLength(0);
    }

    public void observeDungeon(Dungeon dungeon, boolean full, long timestampMillis) {
        this.dungeon = dungeon;
        if (this.firstObserve) {
            this.processDungeonFull(dungeon);
            this.inputGenerator.prepareStaticPart(dungeon, this.domainName, this.roomsWithSword);
            this.firstObserve = false;
        } else {
            this.processDungeonUpdate(dungeon);
        }
    }

    protected int dang(Room r) {
        if (r.monster != null && this.hero.hand == null) {
            return 0;
        }
        if (r.feature != null) {
            if (this.hero.hand != null) {
                return 0;
            }
            return 1;
        }
        if (this.hero.hand != null) {
            return Integer.MAX_VALUE;
        }
        return this.getClosestMonsterDistance(r);
    }

    protected int dangAfterAction(Command cmd) {
        if (this.hero.atRoom.feature != null) {
            if (cmd.isType(EAction.DISARM)) {
                return Math.max(1, this.getClosestMonsterDistance(this.hero.atRoom) - 1);
            }
            return 0;
        }
        if (this.hero.atRoom.monster != null) {
            if (this.hero.hand == null) {
                return 0;
            }
            Monster m = this.hero.atRoom.monster;
            this.hero.atRoom.monster = null;
            int val = this.dangAfterAction(cmd);
            this.hero.atRoom.monster = m;
            return val;
        }
        if (cmd.isType(EAction.MOVE)) {
            Room target = (Room)this.dungeon.rooms.get(cmd.target.id);
            if (target.monster != null) {
                return this.hero.hand != null ? Integer.MAX_VALUE : 0;
            }
            if (target.feature != null) {
                return this.hero.hand != null ? 0 : 1;
            }
            return this.hero.hand != null ? Integer.MAX_VALUE : this.getClosestMonsterDistance(target) - 1;
        }
        if (cmd.isType(EAction.DROP)) {
            return this.getClosestMonsterDistance(this.hero.atRoom) - 1;
        }
        if (cmd.isType(EAction.PICKUP)) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    protected int getClosestMonsterDistance(Room r) {
        int minDist = Integer.MAX_VALUE;
        AStar astar = new AStar((IAStarHeuristic)new IAStarHeuristic<Room>(){

            public int getEstimate(Room n1, Room n2) {
                return 0;
            }
        });
        for (Room room : this.dungeon.rooms.values()) {
            Path path;
            if (room.monster == null || (path = astar.findPath((INode)room, (INode)r, new IAStarView(){

                public boolean isOpened(Object o) {
                    return ((Room)o).feature == null || !((Room)o).feature.isA((EElement)EFeature.TRAP);
                }
            })) == null) continue;
            minDist = Math.min(minDist, path.getDistanceNodes());
        }
        return minDist;
    }

    protected Monster getClosestMonster(Room r) {
        int minDist = Integer.MAX_VALUE;
        Monster closest = null;
        AStar astar = new AStar((IAStarHeuristic)new IAStarHeuristic<Room>(){

            public int getEstimate(Room n1, Room n2) {
                return 0;
            }
        });
        for (Room room : this.dungeon.rooms.values()) {
            int dist;
            Path path;
            if (room.monster == null || (path = astar.findPath((INode)room, (INode)r, new IAStarView(){

                public boolean isOpened(Object o) {
                    return ((Room)o).feature == null || !((Room)o).feature.isA((EElement)EFeature.TRAP);
                }
            })) == null || (dist = path.getDistanceNodes()) >= minDist) continue;
            minDist = dist;
            closest = room.monster;
        }
        return closest;
    }

    protected void processDungeonFull(Dungeon dungeon) {
        this.monsters.clear();
        this.features.clear();
        this.goalRooms.clear();
        this.roomsWithSword.clear();
        for (Room room : dungeon.rooms.values()) {
            if (room.monster != null) {
                this.monsters.put(room.monster.id, room.monster);
            }
            if (room.feature != null) {
                this.features.put(room.feature.id, room.feature);
            }
            if (room.isGoalRoom()) {
                this.goalRooms.add(room);
            }
            if (room.item == null || !EH.isA((Object)room.item.type, (Object)EItem.SWORD)) continue;
            this.roomsWithSword.add(room);
        }
    }

    protected void processDungeonUpdate(Dungeon dungeon) {
        this.roomsWithSword.clear();
        for (Room room : dungeon.rooms.values()) {
            if (room.monster != null) {
                this.monsters.put(room.monster.id, room.monster);
            }
            if (room.feature != null) {
                this.features.put(room.feature.id, room.feature);
            }
            if (room.item == null || !EH.isA((Object)room.item.type, (Object)EItem.SWORD)) continue;
            this.roomsWithSword.add(room);
        }
    }

    public Command act() {
        List<PDDLAction> plan = this.plan();
        if (plan == null || plan.size() == 0) {
            return null;
        }
        return this.translateAction(plan.get(0));
    }

    protected Command translateAction(PDDLAction action) {
        Command result = null;
        if (action.action == EAction.MOVE) {
            Room room1 = (Room)this.dungeon.rooms.get(action.arg1);
            Room room2 = (Room)this.dungeon.rooms.get(action.arg2);
            if (this.hero.atRoom == room1) {
                result = this.actions.move(room2);
            }
            if (this.hero.atRoom == room2) {
                result = this.actions.move(room1);
            }
            return result;
        }
        result = this.actions.action(action.action, new Element[0]);
        if (this.actionValidator.isValid((Entity)this.hero, result)) {
            return result;
        }
        return null;
    }

    protected List<PDDLAction> plan() {
        return this.plan(null);
    }

    protected List<PDDLAction> plan(String goal) {
        InputFiles inputs;
        System.out.println("PLANNER GOAL:" + goal);
        if (goal == null) {
            inputs = this.inputGenerator.generateFiles(this.hero, this.monsters, this.features, this.roomsWithSword, this.goalRooms, this.problemFile, this.domainFile);
        } else {
            ++this.customPlannerCalls;
            inputs = this.inputGenerator.generateFiles(this.hero, this.monsters, this.features, this.roomsWithSword, goal, this.problemFile, this.domainFile);
        }
        if (inputs.problemFile == null) {
            throw new RuntimeException("Failed to genereate problem file!");
        }
        try {
            ++this.plannerCalls;
            List<PDDLAction> plan = this.execPlanner(inputs.domainFile, inputs.problemFile);
            if (plan == null) {
                ++this.failedPlans;
            }
            List<PDDLAction> list = plan;
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute the planner.", e);
        }
        finally {
            try {
                this.problemFile.delete();
            }
            catch (Exception exception) {}
        }
    }

    protected List<PDDLAction> execPlanner(File domainFile, File problemFile) throws Exception {
        return this.executor.execPlanner(domainFile, problemFile);
    }

    protected File getWorkingFile(String name) {
        return new File(this.agentWorkingDir, name);
    }

    public List<String> getCSVHeaders() {
        List headers = super.getCSVHeaders();
        headers.add("planner_calls");
        headers.add("planner_fails");
        return headers;
    }

    public CSV.CSVRow getCSVRow() {
        CSV.CSVRow row = super.getCSVRow();
        row.add("planner_calls", Integer.toString(this.plannerCalls));
        row.add("planner_fails", Integer.toString(this.failedPlans));
        row.add("custom_planner_calls", Integer.toString(this.customPlannerCalls));
        return row;
    }
}

